% PURE seasaltacc optical properties in Mixing layer
% Npureseasaltacc2.m
% One radius and one sigma
% 12 April 2012
% Roberto Pedrs pedrose@uv.es

% READING seasaltacc INPUT PARAMETERS: RADIUS AND SIGMA
function LRT2=Npureseasaltacc(Rseasaltacc0, sigma)
  global lambda ext_coef sca_coef abs_coef ssa asym_param ABS_AMPLIF
 

 eval(['load layer.txt']); 
 laye=layer(:,1);
 
% Growth using the Khler equation
 %eval(['load gro.txt']);
 %growth=gro(:,1);
 %Rseasaltcoa=Rseasaltcoa0*growth;

 % Checking if user-defined growth has been selected
 filegrossa=fopen('growthss.txt', 'r');
 if (filegrossa==-1) % default hygroscopic growth

 % Hygroscopic growth by Gerber (1985)
 %  Gerber HE (1985) Relative humidity parameterization of the Navy
 %  Aerosol Model (NAM).Navy Research Lab, Washington DC

 % Reading RH (%)
  eval(['load hr.txt']);
  hum=hr(:, 1);
  RH=hum/100.0;
  rd=Rseasaltacc0;

  C1=0.7674;
  C2=3.079;
  C3=2.572e-11;
  C4=-1.424;
  rw=( C1*rd^C2/(C3*rd^C4-log(RH)) + rd^3   )^(1/3);

  Rseasaltacc=rw;
 else
  eval(['load growthss.txt']);
  growth=growthss(:, 1)
  Rseasaltacc=Rseasaltacc0*growth;
 end


 % READING THE UNITS SELECTION: 1 is km-1; 0 is m2/g
 eval(['load units.txt;']);
 unit=units(:,1);
 
 % READING DENSITY (g/cm3)
 eval(['load LAYER', num2str(laye), '/denseasalt.txt'])
 dens0=denseasalt(:,1);

 % Hygroscopic growth in density
 dens=dens0*(Rseasaltacc0/Rseasaltacc)^3+(1-(Rseasaltacc0/Rseasaltacc)^3)*1.0;


 

 eval(['load LAYER', num2str(laye), '/nr_seasalt.txt'])
 lamso=nr_seasalt(:, 1);
 nsor=nr_seasalt(:, 2);
 nsoi=nr_seasalt(:, 3); 

  % Determining the step in the lognormal integration dj 
  if Rseasaltacc<0.02  
   dj=0.001;
  else Rseasaltacc>=0.02
   if sigma<1.4
    dj=0.001;
   end
   if sigma>=1.4
    dj=0.01;
   end
  end

 % seasaltacc output file
 fileseasaltacc=fopen('out_pseasaltacc.txt', 'w'); 
 % Headers
 % fprintf(fileseasaltacc, 'lambda\text_coef\tsca_coef\tabs_coef\tssa\tasym_param\n');

 

  % It shows a bar with the status      
  h = waitbar(0,'Computing pure seasaltacc. Please wait...');
  for k = 1:27 % wavelength loop
   lambda=lamso(k);
   m1=nsor(k)+i*nsoi(k);

 
   %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
   %%%%%%%%%%% PURE seasaltacc ABSORPTION COEFFICIENT %%%%%%%%%%%%%%

   ext_coefp=0;
   sca_coefp=0;
   asy_par1p=0;
   asy_par2p=0;
   abs_coefp=0;   % initialization
   vol_tot=0;



   for j = 5e-3:dj:1+Rseasaltacc   %j is the particle radius
    xp=2*pi*j/lambda;
    Ap=Mie(m1, xp);
    Qextp=Ap(:, 1); %efficiency for extinction
    Qscap=Ap(:, 2); %efficiency for scattering
    Qabsp=Ap(:, 3); %efficiency for absorption
    Qbp=Ap(:, 4);   %efficiency for backscattering
    gp=Ap(:, 5);    %asymmetry parameter
    qratiop=Ap(:, 6); % backscattering / scattering
    nrp=lognormal(j, Rseasaltacc, sigma); % lognormal size distribution
                                % particles per m3
    vol_tot=vol_tot+(4*pi/3)*Rseasaltacc^3*nrp*dj;
  
    sigma_ep=pi*j^2*Qextp*nrp*dj;  % extinction coefficient value
    sigma_sp=pi*j^2*Qscap*nrp*dj;  % scattering coefficient value
    sigma_ap=pi*j^2*Qabsp*nrp*dj;  % absorption coefficient value
    sigma_gp=gp*nrp*dj;     % asymmetry parameter (integrated for the size distribution)
    
    ext_coefp=ext_coefp+sigma_ep;      % extinction coefficient integration
    abs_coefp=abs_coefp+sigma_ap;      % absorption coefficient integration
    sca_coefp=sca_coefp+sigma_sp;      % scattering coefficient integration
    asy_par1p=asy_par1p+gp*pi*j^2*Qscap*nrp*dj;        % asymmetry parameter integration
    asy_par2p=asy_par2p+pi*j^2*Qscap*nrp*dj;
   
   
   end 
   ssap=sca_coefp/ext_coefp; %single scattering albedo
   asy_parp=asy_par1p/asy_par2p;

    if unit==1   
     % We have to include a 1e-3 factor to convert from micr2/cm3 into km2/km3=km-1
     fprintf(fileseasaltacc, '%d\t%d\t%d\t%d\t%d\t%d\n', lambda, ext_coefp*1e-3, sca_coefp*1e-3, abs_coefp*1e-3, ssap, asy_parp); 
   elseif unit==0
     fprintf(fileseasaltacc, '%d\t%d\t%d\t%d\t%d\t%d\n', lambda, ext_coefp/(vol_tot*dens), sca_coefp/(vol_tot*dens), abs_coefp/(vol_tot*dens), ssap, asy_parp);
   end

   
  waitbar(k/27,h); 
  end
  close(h);
  fclose(fileseasaltacc);
  eval(['copyfile out_pseasaltacc.txt LAYER', num2str(laye),'/out_pseasaltacc.txt f']);
 eval(['load LAYER', num2str(laye), '/out_pseasaltacc.txt']) ; 
 control=out_pseasaltacc(:,2);
 if isnan(control)==1
     errordlg('INVALID seasaltacc PARAMETERS','ERROR');
 end
 LRT2=out_pseasaltacc;



sound(10)
  
 
