% SOOT COATED SPHERE WITH ORGANIC CARBON (oc) 
% from C10_TB_Rsoot.m file
%  The relative humidity is taken into account through a change in the
%  refractive index of oc

% 9 February 2011
% For absorption amplification calculations
% Roberto Pedrs pedrose@uv.es

% Type 2: 2 euro coin coating 
% The core and shell are different entities (the core is not  a "filling")
% fcoat is the fractional increase in diameter due to coating
% fcoat=(Rshell-Rcore)/Rcore

function LRT3=Nsoot_oc(Rsoot, sigma, fcoat, lay)
global lambda ext_coef sca_coef abs_coef ssa asym_param ABS_AMPLIF

% Parameters from Tami Bond personal communication

% Output file
% Headers

 %eval(['load layer.txt']);
 %lay=layer(:,1);

% READING THE UNITS SELECTION: 1 is km-1; 0 is m2/g
eval(['load units.txt;']);
unit=units(:,1);

% READING CORE DENSITY (g/cm3)
eval(['load LAYER', num2str(lay), '/SOOTOC/densoot.txt'])
dens=densoot(:, 1);

 filecoated=fopen('coated_soot_oc.txt', 'w'); 
 % fprintf(filecoated, 'LAMBDA\text_coef\tsca_coef\tabs_coef\tssa\tasym_param\n');


 
 % 1 corresponds to core:  soot
 % 2 corresponds to shell: oc

% Checking if hygroscopic growth has been selected
 eval(['load LAYER', num2str(lay), '/SOOTOC/ifsoot_rh.txt'])  
 ifhum=ifsoot_rh(:, 1);
 % 0: no growth; 1: growth

 if (ifhum==0)
 % Dry OC hydrophilic
  eval(['load NRHR/ocphi.txt'])  
  lams=ocphi(:, 1);
  nsr=ocphi(:, 2);
  nsi=ocphi(:, 3);
 else
  eval(['load NRHR/ocphi.txt'])  
  lams=ocphi(:, 1);
  nsrd=ocphi(:, 2);
  nsid=ocphi(:, 3);
 
  eval(['load NRHR/water.txt'])
  nwr=water(:, 2);
  nwi=water(:, 3);

  eval(['load gro.txt']);
  growth=gro(:,1);  % from the Kohler's equation

  Ddry=2.0*Rsoot*(1+fcoat); % shell diameter: dry
  Dwet=Ddry*growth;

  % VOLUMEN WEIGHTED REFRACTIVE INDEX OF HYDRATED OC
  nsr=(Ddry^3*nsrd+(Dwet^3-Ddry^3)*nwr)/Dwet^3;
  nsi=(Ddry^3*nsid+(Dwet^3-Ddry^3)*nwi)/Dwet^3;

 end


file12=fopen('tmp_nr_ocphi.txt', 'w')
for k=1:24
 fprintf(file12, '%d\t%d\t%d\n', lams(k), nsr(k), nsi(k));
end
fclose(file12);
 eval(['copyfile tmp_nr_ocphi.txt LAYER', num2str(lay), '/nr_ocphi_SOOT.txt f'])


  % fcoat input
 eval(['load LAYER', num2str(lay), '/SOOTOC/tmp_fcoat_soot.txt'])  ;
 fcoat=tmp_fcoat_soot(:, 1);

 
 % Reading refractive indice of soot (core: c)
 % Reading refractive index of soot:
 % In 0.400 - 0.700 microns the data come from 
 % Bond TC, Bergstrom RW (20069, Light absorption by carbonaceous 
 % particles: An investigative review, AEROSOL SCIENCE AND
 % TECHNOLOGY 40, 27-67.  
 %
 % The rest of wavelengths come from D'Almeida (1991) climatology.
 eval(['load LAYER', num2str(lay), '/SOOTOC/nr_soot2.txt'])
 lamso=nr_soot2(:, 1);
 nsor=nr_soot2(:, 2);
 nsoi=nr_soot2(:, 3); 
 
 h = waitbar(0,'Computing oc coated soot. Please wait...');
 for k = 1:1:27 % wavelength selection
 % for k = 6:1:6 % wavelength selection
  lambda=lams(k); % in microns
   m1=nsor(k)+i*nsoi(k);
   m2=nsr(k)+i*nsi(k);
   
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  %%%%%%%%%%%%%%%%  Soot + oc  %%%%%%%%%%%%%%%%%%%%%%
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
   % initialization
   ext_coef=0;
   sca_coef=0;
   asy_par1=0;
   asy_par2=0;
   abs_coef=0;   
   vol_tot=0;
   
   % Determining the step in the lognormal integration dj 
   if Rsoot<0.02  
    dj=0.001;
   else Rsoot>=0.02
    if sigma<1.4
     dj=0.001;
    else sigma>=1.4
     dj=0.01;
    end  % if sigma<1.4 ends
   end  % if Rsoot<0.02 ends
   
  % Lognormal integration upper limit radius
   if Rsoot>1
    limite=4+Rsoot;
   elseif (Rsoot>=0.5 && Rsoot<1) 
    limite=2+Rsoot;
   else
    limite=1+Rsoot;
   end  % Rsoot>1 ends

   for j = 5e-3:dj:limite % j is the core radius in the lognormal
    Rcore=j;        % core radius
    Rshell=Rcore*(1+fcoat); % shell radius
       % Note that 0<=x<=y;   (Mtzler, 2002).
    % Thus, the minimum shell diameter is the core diameter
    x=2*pi*Rcore/lambda; % Lognormal size distribution for soot (x=2*pi*r/lambda)
    y=2*pi*Rshell/lambda; % oc diameter 
    B=Miecoated(m1,m2,x,y,1);
    
    Qext=B(:, 1); % Efficiency for extinction
    Qsca=B(:, 2); % Efficiency for scattering
    Qabs=B(:, 3); % Efficiency for absorption
    Qb=B(:, 4);   % Efficiency for backscattering
    g=B(:, 5);    % Asymmetry parameter
    qratio=B(:, 6); % Backscattering / scattering
    
    % Lognormal size distribution 
    % (lognormal soot + constant coating)
    lognr=lognormal(Rcore, Rsoot, sigma); 
        
    sigma_e=pi*Rshell^2*Qext*lognr*dj;  % extinction coefficient value
    sigma_s=pi*Rshell^2*Qsca*lognr*dj;  % scattering coefficient value
    sigma_a=pi*Rshell^2*Qabs*lognr*dj;  % absorption coefficient value
    sigma_g=g*lognr*dj;     % asymmetry parameter (integrated for the size distribution)
    
    % total volume calculation
    vol_tot=vol_tot+(4*pi/3)*Rcore^3*lognr*dj;
    
    ext_coef=ext_coef+sigma_e;      % extinction coefficient integration
    abs_coef=abs_coef+sigma_a;      % absorption coefficient integration
    sca_coef=sca_coef+sigma_s;      % scattering coefficient integration
    asy_par1=asy_par1+g*pi*Rshell^2*Qsca*lognr*dj;  % asymmetry parameter integration
    asy_par2=asy_par2+pi*Rshell^2*Qsca*lognr*dj;
     
   end  % for j = 5e-3:dj:limite ends
 
   ssa=sca_coef/ext_coef; %single scattering albedo
   asy_par=asy_par1/asy_par2;

   if abs_coef<0
     abs_coef=0;
   end % abs_coef<0 ends
   % fprintf(filecoated, '%d\t%d\t%d\t%d\t%d\t%d\n', lambda, ext_coef*1e-3, sca_coef*1e-3, abs_coef*1e-3, ssa, asy_par);
   %  fprintf(filecoated, '%d\t%d\t%d\n', Rsoot, 2*Rsoot*pi/lambda, abs_coef*1e-3);


%     if isnan(ext_coef)==0
%     if unit==1   
%      fprintf(filecoated, '%d\t%d\t%d\t%d\t%d\t%d\n', lambda, ext_coef*1e-3, sca_coef*1e-3, abs_coef*1e-3, ssa, asy_par); 
%     elseif unit==0
%         res=zfc8(lambda, Rsoot, sigma, m1, m2, fcoat);
%     fprintf(filecoated, '%d\t%d\t%d\t%d\t%d\t%d\n', lambda, res(2), res(3), res(4), res(5), res(6));
%     end
%    end



    if isnan(ext_coef)==0
    if unit==1   
     fprintf(filecoated, '%d\t%d\t%d\t%d\t%d\t%d\n', lambda, ext_coef*1e-3, sca_coef*1e-3, abs_coef*1e-3, ssa, asy_par); 
    elseif unit==0
     fprintf(filecoated, '%d\t%d\t%d\t%d\t%d\t%d\n', lambda, ext_coef/(vol_tot*dens), sca_coef/(vol_tot*dens), abs_coef/(vol_tot*dens), ssa, asy_par);
    end
   else
    res=zfc8(lambda, Rsoot, sigma, m1, m2, fcoat);   
    fprintf(filecoated, '%d\t%d\t%d\t%d\t%d\t%d\n', lambda, res(2), res(3), res(4), res(5), res(6));
   end

   waitbar(k/27,h);
   
 end  % for k = 1:1:27 ends
 
 close(h);
 eval(['copyfile coated_soot_oc.txt LAYER', num2str(lay),'/coated_soot_oc.txt f']);
 eval(['load LAYER', num2str(lay), '/coated_soot_oc.txt']) ; 
 control=coated_soot_oc(:,2);
 if isnan(control)==1
     errordlg('INVALID PARAMETERS','ERROR');
 end  % isnan(control)==1 ends
 LRT3=coated_soot_oc;

fclose(filecoated);

sound(10)
 
