% SHELL-AND-CORE MODEL 
% in script mode

% from C10_TB_rcore.m file


% 16 July 2012
% 
% Roberto Pedrs pedrose@uv.es

% Type 2: 2 euro coin coating 
% The core and shell are different entities (the core is not  a "filling")
% fcoat is the fractional increase in diameter due to coating
% fcoat=(Rshell-Rcore)/Rcore


global lambda ext_coef sca_coef abs_coef ssa asym_param ABS_AMPLIF

% Parameters from Tami Bond personal communication

% Output file
% Headers


 filecoated=fopen('z_Output.txt', 'w'); 
 % fprintf(filecoated, 'RUN\tLAMBDA\text_coef\tsca_coef\tabs_coef\tssa\tasym_param\n');


 
 % 1 corresponds to core
 % 2 corresponds to shell

 % READING SCRIPT WITH THE FOLLOWING FORMAT
 % run_number	lambda	rcore	sigma	ncore	kcore	fcoatX	nshell	kshell

 eval(['load datos.txt']);
 
 run=datos(:, 1)  
 % wavelength in microns
 lams=datos(:, 2);
 radius=datos(:, 3)
 sigma=datos(:, 4)
 nr1=datos(:, 5);
 ni1=datos(:, 6); 
 fcoatZ=datos(:, 7);
 nr2=datos(:, 8);
 ni2=datos(:, 9); 

 N=size(run, 1);
 
 h = waitbar(0,'Running the model. Please wait...');
 for k = 1:1:N % run selection
 
     
  lambda=lams(k); % in microns
   m1=nr1(k)+i*ni1(k);
   m2=nr2(k)+i*ni2(k);
   
   fcoat=fcoatZ(k);
 % initialization
   ext_coef=0;
   sca_coef=0;
   asy_par1=0;
   asy_par2=0;
   abs_coef=0;   
   vol_tot=0;
   
 % Determining the lower limit for the lognormal integration
  if radius(k)>5e-2
    limiteinf=5e-3;
  else
    limiteinf=radius(k)/100.0;
  end


   
   % Determining the step in the lognormal integration dj 
   if radius(k)<0.02  
    dj=0.001;
   else radius(k)>=0.02
    if sigma<1.4
     dj=0.001;
    else sigma>=1.4
     dj=0.01;
    end  % if sigma<1.4 ends
   end  % if rcore<0.02 ends
   
  % Lognormal integration upper limit radius
   if radius(k)>1
    limite=4*radius(k)+radius(k);
   elseif (radius(k)>=0.5 && radius(k)<1) 
    limite=2+radius(k);
   else
    limite=1+radius(k);
   end  % radius(k)>1 ends
   

%   for j = 5e-3:dj:limite % j is the core radius in the lognormal
 % for j = 0.001:dj:limite % j is the core radius in the lognormal
 for j = limiteinf:dj:limite
    Rcore=j;        % core radius
    Rshell=Rcore*(1+fcoat); % shell radius
       % Note that 0<=x<=y;   (Mtzler, 2002).
    % Thus, the minimum shell diameter is the core diameter
    x=2*pi*Rcore/lambda; % Lognormal size distribution for soot (x=2*pi*r/lambda)
    y=2*pi*Rshell/lambda; % oc diameter 
    B=Miecoated(m1,m2,x,y,1);
    
    Qext=B(:, 1); % Efficiency for extinction
    Qsca=B(:, 2); % Efficiency for scattering
    Qabs=B(:, 3); % Efficiency for absorption
    Qb=B(:, 4);   % Efficiency for backscattering
    g=B(:, 5);    % Asymmetry parameter
    qratio=B(:, 6); % Backscattering / scattering
    
    % Lognormal size distribution 
    % (lognormal soot + constant coating)
    lognr=lognormal(Rcore, radius(k), sigma(k)); 
        
    sigma_e=pi*Rshell^2*Qext*lognr*dj;  % extinction coefficient value
    sigma_s=pi*Rshell^2*Qsca*lognr*dj;  % scattering coefficient value
    sigma_a=pi*Rshell^2*Qabs*lognr*dj;  % absorption coefficient value
    sigma_g=g*lognr*dj;     % asymmetry parameter (integrated for the size distribution)
    
    % total volume calculation
    vol_tot=vol_tot+(pi/6)*Rcore^3*lognr*dj;
    
    ext_coef=ext_coef+sigma_e;      % extinction coefficient integration
    abs_coef=abs_coef+sigma_a;      % absorption coefficient integration
    sca_coef=sca_coef+sigma_s;      % scattering coefficient integration
    asy_par1=asy_par1+g*pi*Rshell^2*Qsca*lognr*dj;  % asymmetry parameter integration
    asy_par2=asy_par2+pi*Rshell^2*Qsca*lognr*dj;
     
   end  % for j = 5e-3:dj:limite ends
 
   ssa=sca_coef/ext_coef; %single scattering albedo
   asy_par=asy_par1/asy_par2;

   if abs_coef<0
     abs_coef=0;
   end % abs_coef<0 ends
   if isnan(ext_coef)==0
    fprintf(filecoated, '%d\t%d\t%d\t%d\t%d\t%d\n', k, ext_coef*1e-3, sca_coef*1e-3, abs_coef*1e-3, ssa, asy_par);
   else
    res=zfc8(lambda, radius(k), sigma(k), m1, m2, fcoat);   
    fprintf(filecoated, '%d\t%d\t%d\t%d\t%d\t%d\n', 999, res(2), res(3), res(4), res(5), res(6));
   end
   waitbar(k/N,h);
 end
 
 close(h);
 

fclose(filecoated);
eval(['load z_Output.txt']) ; 
control=z_Output(:,2);
if isnan(control)==1
  errordlg('INVALID PARAMETERS','ERROR');
end  % isnan(control)==1 ends
 

sound(10)
%       load handel
 %     sound(y,Fs)

