% Optical properties of the pure component


% 19 July 2012
% Roberto Pedrs pedrose@uv.es



 
 % READING SCRIPT WITH THE FOLLOWING FORMAT
 % run_number	lambda	rcore	sigma	ncore	kcore	fcoatX	nshell	kshell
 
 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 %  radius and wavelength in nm   %
 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 
 eval(['load datos.txt']);
 
 run=datos(:, 1);  
 lams=datos(:, 2);
 radius=datos(:, 3);
 sigma=datos(:, 4);
 nr1=datos(:, 5);
 ni1=datos(:, 6); 


 N=size(run, 1); 

 filepure=fopen('z_Output_pure.txt', 'w'); 
 % fprintf(filecoated, 'RUN\tLAMBDA\text_coef\tsca_coef\tabs_coef\tssa\tasym_param\n');

  % It shows a bar with the status      
  h = waitbar(0,'Computing pure user defined mode. Please wait...');
  for k = 1:N % wavelength loop
   lambda=lams(k); % in microns
   m1=nr1(k)+i*ni1(k);
   
   %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
   %%%%%%%%%%% PURE ABSORPTION COEFFICIENT %%%%%%%%%%%%%%

   ext_coefp=0;
   sca_coefp=0;
   asy_par1p=0;
   asy_par2p=0;
   abs_coefp=0;   % initialization

   
  % Determining the lower limit for the lognormal integration
  if radius(k)>5e-2
    limiteinf=5e-3;
   else
     limiteinf=radius(k)/10.0;
   end

   
   % Determining the step in the lognormal integration dj 
   if radius(k)<0.02  
    dj=0.001;
   else radius(k)>=0.02
    if sigma(k)<1.4
     dj=0.001;
    else sigma(k)>=1.4
     dj=0.01;
    end  % if sigma<1.4 ends
   end  % if rcore<0.02 ends
   
  % Lognormal integration upper limit radius
  %if radius(k)>1
  %  limite=4+radius(k);
  % elseif (radius(k)>=0.5 && radius(k)<1) 
  %  limite=2+radius(k);
  % else
  %  limite=1+radius(k);
  % end  % radius(k)>1 ends

limite=4+radius(k)

   for j = limiteinf:dj:limite   %j is the particle radius
    xp=2*pi*j/lambda;
    Ap=Mie(m1, xp);
    
    Qextp=Ap(:, 1); %efficiency for extinction
    Qscap=Ap(:, 2); %efficiency for scattering
    Qabsp=Ap(:, 3); %efficiency for absorption
    Qbp=Ap(:, 4);   %efficiency for backscattering
    gp=Ap(:, 5);    %asymmetry parameter
    qratiop=Ap(:, 6); % backscattering / scattering
    
 
        
    
    nrp=lognormal(j, radius(k), sigma(k)); % lognormal size distribution
                                % particles per m3
  
    sigma_ep=pi*j^2*Qextp*nrp*dj;  % extinction coefficient value
    sigma_sp=pi*j^2*Qscap*nrp*dj;  % scattering coefficient value
    sigma_ap=pi*j^2*Qabsp*nrp*dj;  % absorption coefficient value
    sigma_gp=gp*nrp*dj;     % asymmetry parameter (integrated for the size distribution)
    
    ext_coefp=ext_coefp+sigma_ep;      % extinction coefficient integration
    abs_coefp=abs_coefp+sigma_ap;      % absorption coefficient integration
    sca_coefp=sca_coefp+sigma_sp;      % scattering coefficient integration
    asy_par1p=asy_par1p+gp*pi*j^2*Qscap*nrp*dj;        % asymmetry parameter integration
    asy_par2p=asy_par2p+pi*j^2*Qscap*nrp*dj;
   
   
   end 
   ssap=sca_coefp/ext_coefp; %single scattering albedo
   asy_parp=asy_par1p/asy_par2p;

   % We have to include a 1e-3 factor to convert from micr2/cm3 into km2/km3=km-1
   fprintf(filepure, '%d\t%d\t%d\t%d\t%d\t%d\n', k, ext_coefp*1e-3, sca_coefp*1e-3, abs_coefp*1e-3, ssap, asy_parp);

   
  waitbar(k/N,h); 
  end
  close(h);
  fclose(filepure);
  eval(['load z_Output_pure.txt']) ; 
  control=z_Output_pure(:,2);
 if isnan(control)==1
   errordlg('INVALID MODE PARAMETERS','ERROR');
   exit;
 end
 



sound(10);
  
 
