% a_EEMA
% Calculation of the effective refractive index following the
%  Extended Efective Medium Aproximation (EEMA)

%%%%%%%  INPUT
%  Input TEXT file (in INPUTS folder) will have the following columns',...
%     '__________________________________________________________________',...
%     ' ',...
%     '(1) (2) (3) (4) (5) (6) (7) (8) (9) (10) (11) ',...
%     '___________________________________________________________________',...
%     '(1)  Counter: integer from 1 to N (N: number of runs)',...
%     '(2)  lambda: wavelength in micrometers',...
%     '(3)  Rmod: modal radius (micr) of the size distribution',...
%     '(4)  Sigma: standard deviation of the size distribution',...
%     '(5)  denstot: total density',...
%     '(6)  n0: host real part of the refractive index',...
%     '(7)  k0: host imaginary part of the core refractive index',...
%     '(8)  n1: inclusion real part of the refractive index',...
%     '(9)  k1: inclusion imaginary part of the refractive index',...
%     '(10) a1: inclusion radius (micr)',...
%     '(11) f1: inclusion volume fraction',...


eval(['load datos1.txt']);

 Counter=datos1(:, 1);
 lambda=datos1(:, 2);
 Rmod=datos1(:, 3);
 Sigma=datos1(:, 4);
 denstot=datos1(:, 5);
 n0=datos1(:, 6);
 k0=datos1(:, 7);
 n1=datos1(:, 8);
 k1=datos1(:, 9);
 a1=datos1(:, 10);
 f1=datos1(:, 11);

 N=size(Counter, 1); 
 
 
 filemodr=fopen('nr_EEMA.txt', 'w');
 fileout=fopen('datos.txt', 'w');

 
 E0=(n0+i*k0).^2;
 E1=(n1+i*k1).^2;
 Er= E1./E0;
  
 x=2*pi*a1./lambda;
 

 Eeff=E0+3*f1.*E0.*(Er-1)./(Er+2).*( 1+(Er-1).*x.*x.*(Er+10)./(10*(Er+2))-i*2*(Er-1).*x.^3./(3*(Er+2))  );
 neff=sqrt(Eeff);

 ntot=real(neff);
 ktot=imag(neff);

 for j=1:N
  fprintf(filemodr, '%f\t%f\t%f\t%f\n', Counter(j), lambda(j), ntot(j), ktot(j));
  fprintf(fileout, '%f\t%f\t%f\t%f\t%f\t%f\t%f\n', Counter(j), lambda(j), Rmod(j), Sigma(j), ntot(j), ktot(j), denstot(j));
 end
  %  run=datos(:, 1);  % counter 1 to N
  %  lams=datos(:, 2); % wavelength (micr) 
  %  radius=datos(:, 3); % Core radius (micr)
  %  sigma=datos(:, 4);  % std dev of the size distribution
  %  nr1=datos(:, 5);   % real part of the core refractive index
  %  ni1=datos(:, 6);   % imaginary part of the core refractive index
  %  dens=datos(:, 7);  % Core density (g cm-3)


 
 fclose(filemodr);
 fclose(fileout);
 fclose all