% a_modal
% Calculation of the effective refractive index following the
% Bruggeman rule

%%%%%%%  INPUT
%  Input TEXT file (in INPUTS folder) will have the following columns',...
%     '__________________________________________________________________',...
%     ' ',...
%     '(1) (2) (3) (4) (5) (6) (7) (8) (9) (10) (11) ...',...
%     '___________________________________________________________________',...
%     '(1)  Counter: integer from 1 to N (N: number of runs)',...
%     '(2)  lambda: wavelength in micrometers',...
%     '(3)  Rmod: modal radius (micr) of the size distribution',...
%     '(4)  Sigma: standard deviation of the size distribution',...
%     '(5)  n1: component 1 real part of the refractive index ',...
%     '(6)  k1: component 1 imaginary part of the refractive index ',...
%     '(7)  denstot: total density (g/cm3) ',...
%     '(8)  f1: component 1 volume fraction',...
%     '(9)  n2: component 2 real part of the refractive index ',...
%     '(10) k2: component 2 imaginary part of the refractive index ',...
%     '(11) f2: component 2 volume fraction',...

%     ' ', ...
%     ' If necessary up to 3 components more can be added. ',...
%     ' For this, you should add a set of three colums per component : ',... 
%     '    ', ...
%     '(12) n3: component 3 real part of the refractive index ',...
%     '(13) k3: component 3 imaginary part of the refractive index ',...
%     '(14) f3: component 3 volume fraction',...
%     '    ', ...
%     '   and so on   ', ...

warning off

eval(['load datos1.txt']);
jol=size(datos1);
tama=jol(2);  % total column number

 Counter=datos1(:, 1);
 lambda=datos1(:, 2);
 Rmod=datos1(:, 3);
 Sigma=datos1(:, 4);
 denstot=datos1(:, 5);
 n1=datos1(:, 6);
 k1=datos1(:, 7);
 f1=datos1(:, 8);
 n2=datos1(:, 9);
 k2=datos1(:, 10);
 f2=datos1(:, 11);

 
 cero=0*datos1(:, 1);
 
 switch tama
   case 14
     n3=datos1(:, 12);
     k3=datos1(:, 13);
     f3=datos1(:, 14);
     n4=cero; k4=cero; f4=cero; n5=cero; k5=cero; f5=cero;
   case 17
     n3=datos1(:, 12);
     k3=datos1(:, 13);
     f3=datos1(:, 14);
     n4=datos1(:, 15);
     k4=datos1(:, 16);
     f4=datos1(:, 17);    
     n5=cero; k5=cero; f5=cero;
   case 20
     n3=datos1(:, 12);
     k3=datos1(:, 13);
     f3=datos1(:, 14);
     n4=datos1(:, 15);
     k4=datos1(:, 16);
     f4=datos1(:, 17);   
     n5=datos1(:, 18);
     k5=datos1(:, 19);
     f5=datos1(:, 20); 

 end
 

 N=size(Counter, 1); 
 
 
 filemodr=fopen('nr_bruggeman.txt', 'w');
 fileout=fopen('datos.txt', 'w');

 
 % Eeff: complex dielectric constant: the solution of an equation
 syms Eeff

   
   switch tama
    case 11
       for j=1:N  
        E1=(n1(j)+i*k1(j)).^2;
        E2=(n2(j)+i*k2(j)).^2;
  
        Etot2=solve(f1(j)*(E1-Eeff)/(E1+2*Eeff)+f2(j)*(E2-Eeff)/(E2+2*Eeff)==0);
        Etot22=double(Etot2);
        ntot22=sqrt(Etot22);
        ntot2=real(ntot22);
        ktot2=imag(ntot22);
    
        ntot=ntot2(1);
        ktot=ktot2(1);
        fprintf(filemodr, '%f\t%f\t%f\t%f\n', Counter(j), lambda(j), ntot, ktot);
        fprintf(fileout, '%f\t%f\t%f\t%f\t%f\t%f\t%f\n', Counter(j), lambda(j), Rmod(j), Sigma(j), ntot, ktot, denstot(j));

       end
   case 14
       for j=1:N  
        E1=(n1(j)+i*k1(j)).^2;
        E2=(n2(j)+i*k2(j)).^2;
        E3=(n3(j)+i*k3(j)).^2;
        Etot3=solve(f1(j)*(E1-Eeff)/(E1+2*Eeff)+f2(j)*(E2-Eeff)/(E2+2*Eeff)+f3(j)*(E3-Eeff)/(E3+2*Eeff)==0);
        Etot33=double(Etot3);
        ntot33=sqrt(Etot33);
        ntot3=real(ntot33);
        ktot3=imag(ntot33);
    
        ntot=ntot3(1);
        ktot=ktot3(1);
        fprintf(filemodr, '%f\t%f\t%f\t%f\n', Counter(j), lambda(j), ntot, ktot);
        fprintf(fileout, '%f\t%f\t%f\t%f\t%f\t%f\t%f\n', Counter(j), lambda(j), Rmod(j), Sigma(j), ntot, ktot, denstot(j));
       end
    case 17
        for j=1:N  
        E1=(n1(j)+i*k1(j)).^2;
        E2=(n2(j)+i*k2(j)).^2;
        E3=(n3(j)+i*k3(j)).^2;
        E4=(n4(j)+i*k4(j)).^2;
        Etot4=solve(f1(j)*(E1-Eeff)/(E1+2*Eeff)+f2(j)*(E2-Eeff)/(E2+2*Eeff)+f3(j)*(E3-Eeff)/(E3+2*Eeff)+f4(j)*(E4-Eeff)/(E4+2*Eeff)==0);
        Etot44=double(Etot4);
        ntot44=sqrt(Etot44);
        ntot4=real(ntot44);
        ktot4=imag(ntot44);
    
        ntot=ntot4(1);
        ktot=ktot4(1);
        fprintf(filemodr, '%f\t%f\t%f\t%f\n', Counter(j), lambda(j), ntot, ktot);
        fprintf(fileout, '%f\t%f\t%f\t%f\t%f\t%f\t%f\n', Counter(j), lambda(j), Rmod(j), Sigma(j), ntot, ktot, denstot(j));
        end
    case 20
        for j=1:N  
        E1=(n1(j)+i*k1(j)).^2;
        E2=(n2(j)+i*k2(j)).^2;
        E3=(n3(j)+i*k3(j)).^2;
        E4=(n4(j)+i*k4(j)).^2;
        E5=(n5(j)+i*k5(j)).^2;
        Etot5=solve(f1(j)*(E1-Eeff)/(E1+2*Eeff)+f2(j)*(E2-Eeff)/(E2+2*Eeff)+f3(j)*(E3-Eeff)/(E3+2*Eeff)+f4(j)*(E4-Eeff)/(E4+2*Eeff)+f5(j)*(E5-Eeff)/(E5+2*Eeff)==0);
        Etot55=double(Etot5);
        ntot55=sqrt(Etot55);
        ntot5=real(ntot55);
        ktot5=imag(ntot55);
    
        ntot=ntot5(1);
        ktot=ktot5(1);
        fprintf(filemodr, '%f\t%f\t%f\t%f\n', Counter(j), lambda(j), ntot, ktot);
        fprintf(fileout, '%f\t%f\t%f\t%f\t%f\t%f\t%f\n', Counter(j), lambda(j), Rmod(j), Sigma(j), ntot, ktot, denstot(j));
        end

  end

 

 % fprintf(fileout, '%f\t%f\t%f\t%f\t%f\t%f\t%f\n', Counter, lambda, Rmod, Sigma, ntot, ktot, denstot);
  %  run=datos(:, 1);  % counter 1 to N
  %  lams=datos(:, 2); % wavelength (micr) 
  %  radius=datos(:, 3); % Core radius (micr)
  %  sigma=datos(:, 4);  % std dev of the size distribution
  %  nr1=datos(:, 5);   % real part of the core refractive index
  %  ni1=datos(:, 6);   % imaginary part of the core refractive index
  %  dens=datos(:, 7);  % Core density (g cm-3)


 
 fclose(filemodr);
 fclose(fileout);
 fclose all