% a_modal
% Calculation of the effective refractive index following the
%  Maxwell-Garnett rule

%%%%%%%  INPUT
%  Input TEXT file (in INPUTS folder) will have the following columns',...
%     '__________________________________________________________________',...
%     ' ',...
%     '(1) (2) (3) (4) (5) (6) (7) (8) (9) (10) (11) (12) (13) ...',...
%     '___________________________________________________________________',...
%     '(1)  Counter: integer from 1 to N (N: number of runs)',...
%     '(2)  lambda: wavelength in micrometers',...
%     '(3)  Rmod: modal radius (micr) of the size distribution',...
%     '(4)  Sigma: standard deviation of the size distribution',... 
%     '(6)  n0: HOST real part of the refractive index ',...
%     '(7)  k0: HOST imaginary part of the refractive index ',...
%     '(8)  denstot: total density (g/cm3) ',...
%     '(8)  n1: [inclusion 1] real part of the refractive index',...
%     '(9)  k1: [inclusion 1] imaginary part of the core refractive index',...
%     '(10) f1: [inclusion 1 volume fraction',...
%     ' ', ...
%     ' If necessary up to 5 inclusions more can be added. ',...
%     ' For this, you should add a set of three colums per inclusion: ',... 
%     '    ', ...
%     '(11) n2: [inclusion 2] real part of the refractive index',...
%     '(12) k2: [inclusion 2] imaginary part of the core refractive index',...
%     '(13) f2: [inclusion 2] volume fraction',...
%     '    ', ...
%     '   and so on   ', ...
 
eval(['load datos1.txt']);
jol=size(datos1);
tama=jol(2);  % total column number

 Counter=datos1(:, 1);
 lambda=datos1(:, 2);
 Rmod=datos1(:, 3);
 Sigma=datos1(:, 4);
 denstot=datos1(:, 5);
 n0=datos1(:, 6);
 k0=datos1(:, 7);
 cero=0*datos1(:, 1);
 
 switch tama
   case 10
     n1=datos1(:, 8);
     k1=datos1(:, 9);
     f1=datos1(:, 10);
     n2=cero; n3=cero; n4=cero; k2=cero; k3=cero; k4=cero; f2=cero; f3=cero; f4=cero; n5=cero; k5=cero; f5=cero;
   case 13
     n1=datos1(:, 8);
     k1=datos1(:, 9);
     f1=datos1(:, 10);
     n2=datos1(:, 11);
     k2=datos1(:, 12);
     f2=datos1(:, 13);
     n3=cero; n4=cero; k3=cero; k4=cero; f3=cero; f4=cero; n5=cero; k5=cero; f5=cero;
   case 16
     n1=datos1(:, 8);
     k1=datos1(:, 9);
     f1=datos1(:, 10);
     n2=datos1(:, 11);
     k2=datos1(:, 12);
     f2=datos1(:, 13);
     n3=datos1(:, 14);
     k3=datos1(:, 15);
     f3=datos1(:, 16);
     n4=cero; k4=cero; f4=cero; n5=cero; k5=cero; f5=cero;
   case 19
     n1=datos1(:, 8);
     k1=datos1(:, 9);
     f1=datos1(:, 10);
     n2=datos1(:, 11);
     k2=datos1(:, 12);
     f2=datos1(:, 13);
     n3=datos1(:, 14);
     k3=datos1(:, 15);
     f3=datos1(:, 16);
     n4=datos1(:, 17);
     k4=datos1(:, 18);
     f4=datos1(:, 19);    
     n5=0; k5=cero; f5=cero;
   case 22
     n1=datos1(:, 8);
     k1=datos1(:, 9);
     f1=datos1(:, 10);
     n2=datos1(:, 11);
     k2=datos1(:, 12);
     f2=datos1(:, 13);
     n3=datos1(:, 14);
     k3=datos1(:, 15);
     f3=datos1(:, 16);
     n4=datos1(:, 17);
     k4=datos1(:, 18);
     f4=datos1(:, 19);   
     n5=datos1(:, 20);
     k5=datos1(:, 21);
     f5=datos1(:, 22); 

 end
 

 N=size(Counter, 1); 
 
 
 filemodr=fopen('nr_maxwell.txt', 'w');
 fileout=fopen('datos.txt', 'w');

 
   % Eeff: complex dielectric constant
    E0=(n0+i*k0).^2;
   switch tama
   case 10
    E1=(n1+i*k1).^2;
    E2=0;
    E3=0;
    E4=0; 
    E5=0; 
   case 13
    E1=(n1+i*k1).^2;
    E2=(n2+i*k2).^2;
    E3=0;
    E4=0; 
    E5=0; 
   case 16
    E1=(n1+i*k1).^2;   
    E2=(n2+i*k2).^2;
    E3=(n3+i*k3).^2;
    E4=0;
    E5=0; 
   case 19
    E1=(n1+i*k1).^2;   
    E2=(n2+i*k2).^2;
    E3=(n3+i*k3).^2;
    E4=(n4+i*k4).^2; 
    E5=0; 
   case 22
    E1=(n1+i*k1).^2;   
    E2=(n2+i*k2).^2;
    E3=(n3+i*k3).^2;
    E4=(n4+i*k4).^2; 
    E5=(n5+i*k5).^2; 
 end

   I1=f1.*(E1-E0)./(E1+2*E0);
   I2=f2.*(E2-E0)./(E2+2*E0);
   I3=f3.*(E3-E0)./(E3+2*E0);
   I4=f4.*(E4-E0)./(E4+2*E0);
   I5=f5.*(E5-E0)./(E5+2*E0);
   
   Itot=I1+I2+I3+I4+I5;
   Etot=E0.*(1+2*Itot)./(1-Itot);
   
   ref_tot=sqrt(Etot);
   ntot= real(ref_tot);
   ktot=imag(ref_tot);
   
%    real(ref_tot);
%    imag(ref_tot);
   
  for k=1:N 
   fprintf(filemodr, '%f\t%f\t%f\t%f\n', Counter(k), lambda(k), ntot(k), ktot(k));
   fprintf(fileout, '%f\t%f\t%f\t%f\t%f\t%f\t%f\n', Counter(k), lambda(k), Rmod(k), Sigma(k), ntot(k), ktot(k), denstot(k));
  end
 

 % fprintf(fileout, '%f\t%f\t%f\t%f\t%f\t%f\t%f\n', Counter, lambda, Rmod, Sigma, ntot, ktot, denstot);
  %  run=datos(:, 1);  % counter 1 to N
  %  lams=datos(:, 2); % wavelength (micr) 
  %  radius=datos(:, 3); % Core radius (micr)
  %  sigma=datos(:, 4);  % std dev of the size distribution
  %  nr1=datos(:, 5);   % real part of the core refractive index
  %  ni1=datos(:, 6);   % imaginary part of the core refractive index
  %  dens=datos(:, 7);  % Core density (g cm-3)


 
 fclose(filemodr);
 fclose(fileout);
 fclose all