% a_modal
% Calculation of the effective refractive index following the
%  molar refraction and absorption

%%%%%%%  INPUT
%  Input TEXT file (in INPUTS folder) will have the following columns',...
%     '__________________________________________________________________',...
%     ' ',...
%     '(1) (2) (3) (4) (5) (6) (7) (8) (9) (10) (11) (12) (13) (14) (15) (16)',...
%     '___________________________________________________________________',...
%     '(1) Counter: integer from 1 to N (N: number of runs)',...
%     '(2)  lambda: wavelength in micrometers',...
%     '(3)  Rmod: modal radius (micr) of the size distribution',...
%     '(4)  Sigma: standard deviation of the size distribution',...
%     '(5)  n1: component 1 real part of the refractive index',...
%     '(6)  k1: component 1imaginary part of the core refractive index',...
%     '(7)  dens1: component1 density (g/cm3)',...
%     '(8)  M1: component1 molecular mass (g)',...
%     '(9)  X1: component 1 molar fraction',...
%     '(10) n2: component 2 real part of the refractive index',...
%     '(11) k2: component 1imaginary part of the core refractive index',...
%     '(12) dens2: component1 density (g/cm3)',...
%     '(13) M2: component1 molecular mass (g)',...
%     '(14) X2: component 2 molar fraction',...
%     '(15) Mtot: total molecular weight',...
%     '(16) denstot: total density',...


eval(['load datos1.txt']);

 Counter=datos1(:, 1);
 lambda=datos1(:, 2);
 Rmod=datos1(:, 3);
 Sigma=datos1(:, 4);
 n1=datos1(:, 5);
 k1=datos1(:, 6);
 dens1=datos1(:, 7);
 M1=datos1(:, 8);
 X1=datos1(:, 9);
 n2=datos1(:, 10);
 k2=datos1(:, 11);
 dens2=datos1(:, 12);
 M2=datos1(:, 13);
 X2=datos1(:, 14);
 Mtot=datos1(:, 15);
 denstot=datos1(:, 16);
 
 N=size(Counter, 1); 
 
 
 filemodr=fopen('nr_molar.txt', 'w');
 fileout=fopen('datos.txt', 'w');
 
 for k = 1:N % wavelength loop
 
  Vtot(k)=Mtot(k)/denstot(k);
  A1=M1(k)*k1(k)/dens1(k);
  A2=M2(k)*k2(k)/dens2(k);
 
  ktot(k)=(X1(k)*A1+X2(k)*A2)/Vtot(k);
 
  R1(k)=M1(k)*(n1(k)^2-1)/(dens1(k)*(n1(k)^2+2));
  R2(k)=M2(k)*(n2(k)^2-1)/(dens2(k)*(n2(k)^2+2));
 
  a(k)=(X1(k)*R1(k)+X2(k)*R2(k))/Vtot(k);
 
  ntot(k)=sqrt( (1+2*a(k))/(1-a(k)));
 

  fprintf(filemodr, '%f\t%f\t%f\t%f\n', Counter(k), lambda(k), ntot(k), ktot(k));

 

  fprintf(fileout, '%f\t%f\t%f\t%f\t%f\t%f\t%f\n', Counter(k), lambda(k), Rmod(k), Sigma(k), ntot(k), ktot(k), denstot(k));
  %  run=datos(:, 1);  % counter 1 to N
  %  lams=datos(:, 2); % wavelength (micr) 
  %  radius=datos(:, 3); % Core radius (micr)
  %  sigma=datos(:, 4);  % std dev of the size distribution
  %  nr1=datos(:, 5);   % real part of the core refractive index
  %  ni1=datos(:, 6);   % imaginary part of the core refractive index
  %  dens=datos(:, 7);  % Core density (g cm-3)

 end
 
 fclose(filemodr);
 fclose(fileout);
 fclose all