% a_volume
% Calculation of the effective refractive index following the
%  volume-weighted linear average of the refractive indices

%%%%%%%  INPUT
%  Input TEXT file (in INPUTS folder) will have the following columns',...
%     '__________________________________________________________________',...
%     ' ',...
%     '(1) (2) (3) (4) (5) (6) (7) (8) (9) (10) (11) (12) (13) ',...
%     '___________________________________________________________________',...
%     '(1)  Counter: integer from 1 to N (N: number of runs)',...
%     '(2)  lambda: wavelength in micrometers',...
%     '(3)  Rmod: modal radius (micr) of the size distribution',...
%     '(4)  Sigma: standard deviation of the size distribution',...
%     '(5)  n1: component 1 real part of the refractive index',...
%     '(6)  k1: component 1 imaginary part of the core refractive index',...
%     '(7)  dens1: component1 density (g/cm3)',...
%     '(8)  f1: component 1 volume fraction',...
%     '(9)  n2: component 2 real part of the refractive index',...
%     '(10) k2: component 1imaginary part of the core refractive index',...
%     '(11) dens2: component1 density (g/cm3)',...
%     '(12) f2: component 2 volume fraction',...
%     '(13) denstot: total density',...


eval(['load datos1.txt']);

 Counter=datos1(:, 1);
 lambda=datos1(:, 2);
 Rmod=datos1(:, 3);
 Sigma=datos1(:, 4);
 n1=datos1(:, 5);
 k1=datos1(:, 6);
 dens1=datos1(:, 7);
 f1=datos1(:, 8);
 n2=datos1(:, 9);
 k2=datos1(:, 10);
 dens2=datos1(:, 11);
 f2=datos1(:, 12);
 denstot=datos1(:, 13);

 
 N=size(Counter, 1); 
 
 
 filemodr=fopen('nr_volume.txt', 'w');
 fileout=fopen('datos.txt', 'w');
 
 for k = 1:N % wavelength loop
 
  ntot(k)=f1(k)*n1(k)+f2(k)*n2(k);
  ktot(k)=f1(k)*k1(k)+f2(k)*k2(k);
 

  fprintf(filemodr, '%f\t%f\t%f\t%f\n', Counter(k), lambda(k), ntot(k), ktot(k));

 

  fprintf(fileout, '%f\t%f\t%f\t%f\t%f\t%f\t%f\n', Counter(k), lambda(k), Rmod(k), Sigma(k), ntot(k), ktot(k), denstot(k));
  %  run=datos(:, 1);  % counter 1 to N
  %  lams=datos(:, 2); % wavelength (micr) 
  %  radius=datos(:, 3); % Core radius (micr)
  %  sigma=datos(:, 4);  % std dev of the size distribution
  %  nr1=datos(:, 5);   % real part of the core refractive index
  %  ni1=datos(:, 6);   % imaginary part of the core refractive index
  %  dens=datos(:, 7);  % Core density (g cm-3)

 end
 
 fclose(filemodr);
 fclose(fileout);
 fclose all