% MANUAL INTRODUCTION OF BIOMASS REFRACTIVE INDEX
%  AND INTERPOLATION TO MEET THE WAVELENGTH RANGE

% execute this code when user_nr_biomass is selected
eval(['load layer.txt']);
lay=layer(:,1);

quest='USER-DEFINED REFRACTIVE INDEX ';
alt={'Introduce the BIOMASS refractive index.',...
    'Data in 3 columns separated by tabs:',...
    '(1) Wavelength (in microns): from 0.3 to 4.0',...
    '(2) Real part of the refractive index', ...
    '(3) Imaginary part of the refractive index', ...
    ' ', ...
    'The wavelengths should be', ...
    '{0.30, 0.35, 0.40, 0.45, 0.50, 0.55, 0.60, 0.65, 0.70, 0.75, 0.80, 0.85, 0.90, 0.95, 1.00, 1.25, 1.5, 1.75, 2.00, 2.25, 2.5, 2.75, 3.00, 3.25, 3.5, 3.75, 4.00}',...
    '', ... 
    ' Otherwise the values will be interpolated',...
    '', ... 
    ' '};
string=[quest,'\n'];
for j=1:length(alt)
    string=[string,'\n',alt{j}];
end
string=[string,'\n'];
string=sprintf(string);%this makes \n work
prompt={string};
choice = questdlg(prompt, ...
	'USER-DEFINED REFRACTIVE INDEX', ...
	'MANUAL ENTRY','LOAD FILE','QUIT INTERFACE', 'QUIT INTERFACE');
% Handle response
switch choice
    case 'MANUAL ENTRY'
      eval(['delete nr_blank.txt']);
      fileto=fopen('nr_blank.txt', 'w');
      eval(['copyfile nr_blank.txt nr_biomassi.txt f']);
      eval(['edit nr_biomassi.txt']);
      f = figure;
      set(f,'name','CLICK HERE TO RESUME GUI','numbertitle','off')
      h = uicontrol('Position',[20 20 200 40],'String','Resume Gui when done',...
              'Callback','uiresume(gcbf)');
      uiwait(gcf); 
      close(f);
    case 'LOAD FILE'
      perico=pwd;
      local=strcat(pwd, '\nr_biomassi.txt');
      if exist(local)==2
       delete(local);
      end
      backDir = cd;  
      [Filebiomass,Pathbiomass]= uigetfile('*.txt','Select the input file');
      
      ficherobiomass=strcat(Pathbiomass, Filebiomass);
      copyfile(char(ficherobiomass), char(local), 'f');
      cd(backDir);
    case 'QUIT INTERFACE'
      error('QUITTING INTERFACE AS REQUESTED');
end

eval(['load nr_biomassi.txt'])
lam=nr_biomassi(:, 1);
nr=nr_biomassi(:, 2);
ni=nr_biomassi(:, 3);
 

xx=[0.30	0.35	0.40	0.45	0.50	0.55	0.60	0.65	0.70	0.75	0.80	0.85	0.90	0.95	1.0	1.25	1.5	1.75	2.0	2.25	2.5	2.75	3.0	3.25	3.5	3.75	4.0]';
nripolbiomass=spline(lam, nr, xx)';
niipolbiomass=spline(lam, ni, xx)';

Pathbiomass=pwd;
fileipolbiomass=fopen('nr_biomassin.txt', 'w');
for i=1:27
 fprintf(fileipolbiomass, '%d\t%d\t%d\n', xx(i), nripolbiomass(i), niipolbiomass(i));
end
fclose(fileipolbiomass);
fclose all;
eval(['copyfile nr_biomassin.txt LAYER', num2str(lay), '\nr_biomass.txt f']);


