% SOOT COATED SPHERE WITH DRY SULFATE
% C8_TB.m file
% HR=0-37%
% 2 April 2008
% Following Tami Bond's approach
% Roberto Pedrs pedrose@uv.es

% Type 2: 2 euro coin coating 
% The core and shell are different entities (the core is not  a "filling")
% fcoat is the fractional increase in diameter due to coating
% fcoat=(Dshell-Dcore)/Dcore
 warning off
 close all
 clear
 clear all

% Parameters from Tami Bond personal communication

HR=40; 

 GSD=1.1;
 CMD=10; % in nanometers
 sigma=GSD;
 
 % 1 corresponds to core:  soot
 % 2 corresponds to shell: sulfate

 % Reading refractive indice of sulfate
 % After Toon, O., J. Pollack, and B. Khare (1976), The Optical Constants of
 % Several Atmospheric Aerosol Species: Ammonium Sulfate, Aluminum Oxide, 
 % and Sodium Chloride, J. Geophys. Res., 81(33), 5733-5748. 
 eval(['load zsulfate.txt'])  
 lams=zsulfate(:, 1);
 nsr=zsulfate(:, 2);
 nsi=zsulfate(:, 3); 

 % Reading refractive indice of soot (core: c)
 % Reading refractive index of soot:
 % In 0.400 - 0.700 microns the data come from 
 % Bond TC, Bergstrom RW (20069, Light absorption by carbonaceous 
 % particles: An investigative review, AEROSOL SCIENCE AND
 % TECHNOLOGY 40, 27-67.  
 %
 % The rest of wavelengths come from D'Almeida (1991) climatology.
 eval(['load zsoot.txt'])
 lamso=zsoot(:, 1);
 nsor=zsoot(:, 2);
 nsoi=zsoot(:, 3); 
 
 % Output file
 % Headers
 filecoated=fopen('zC8_TB_out100.txt', 'w'); 
 fprintf(filecoated, 'LAMBDA\text_coef\tsca_coef\tabs_coef\tssa\tasym_param\n');

  fcoat = 100.0;  % Ratio particulate/core
 
  for k = 6:1:6 % wavelength selection
   lambda=1e3*lams(k);
   m1=nsor(k)+i*nsoi(k);
   m2=nsr(k)+i*nsi(k);
   
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  %%%%%%%%%%%%%%%%  Soot + sulfate  %%%%%%%%%%%%%%%%%%%%%%
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
   % initialization
   ext_coef=0;
   sca_coef=0;
   asy_par1=0;
   asy_par2=0;
   abs_coef=0;   
   vol_tot=0;
   
   % dlogd=0.0103; % logarithmic differential element
   if (fcoat<=40)
    dlogd = min(1/10, log10(sigma)*.25);     % minimum 12 points across range;    
    limit=floor(4*log(sigma)/dlogd)*dlogd;  % integral number to cover 3.5x gsd
   else
    dlogd = 0.001;
    limit=floor(10*log(sigma)/dlogd)*0.01;;
   end
   
   
       
   
   for j = -limit:dlogd:limit % j is the core diameter in the lognormal
    Dcore=CMD*10^j;        % core diameter
    Dshell=Dcore*(1+fcoat); % shell diameter
       % Note that 0<=x<=y;   (Mtzler, 2002).
    % Thus, the minimum shell diameter is the core diameter
    x=pi*Dcore/lambda; % Lognormal size distribution for soot (x=2*pi*r/lambda)
    y=pi*Dshell/lambda; % Sulfate diameter 
    B=Miecoated(m1,m2,x,y,1);
    
    Qext=B(:, 1); % Efficiency for extinction
    Qsca=B(:, 2); % Efficiency for scattering
    Qabs=B(:, 3); % Efficiency for absorption
    Qb=B(:, 4);   % Efficiency for backscattering
    g=B(:, 5);    % Asymmetry parameter
    qratio=B(:, 6); % Backscattering / scattering
    
    % Lognormal size distribution 
    % (lognormal soot + constant coating)
    lognr=zlognormalTB(Dcore, CMD, GSD); 
        
    sigma_e=pi*(Dshell/2)^2*Qext*lognr*dlogd;  % extinction coefficient value
    sigma_s=pi*(Dshell/2)^2*Qsca*lognr*dlogd;  % scattering coefficient value
    sigma_a=pi*(Dshell/2)^2*Qabs*lognr*dlogd;  % absorption coefficient value
    sigma_g=g*lognr*dlogd;     % asymmetry parameter (integrated for the size distribution)
    
    % total volume calculation
    vol_tot=vol_tot+(pi/6)*Dcore^3*lognr*dlogd;
    
    ext_coef=ext_coef+sigma_e;      % extinction coefficient integration
    abs_coef=abs_coef+sigma_a;      % absorption coefficient integration
    sca_coef=sca_coef+sigma_s;      % scattering coefficient integration
    asy_par1=asy_par1+g*pi*(Dshell/2)^2*Qsca*lognr*dlogd;  % asymmetry parameter integration
    asy_par2=asy_par2+pi*(Dshell/2)^2*Qsca*lognr*dlogd;
   end 
   ssa=sca_coef/ext_coef; %single scattering albedo
   asy_par=asy_par1/asy_par2;

   if abs_coef<0
     abs_coef=0;
   end
  fprintf(filecoated, '%d\t%.9d\t%.9d\t%.9d\t%d\t%d\n', lambda, ext_coef*1e3/vol_tot, sca_coef*1e3/vol_tot, abs_coef*1e3/vol_tot, ssa, asy_par);
  end


fclose(filecoated);

sound(10)
 
