% SOOT COATED SPHERE WITH DRY SULFATE
% C8_TB.m file
% HR=0-37%
% 2 April 2008
% Following Tami Bond's approach
% Roberto Pedrs pedrose@uv.es

% Type 2: 2 euro coin coating 
% The core and shell are different entities (the core is not  a "filling")
% fcoat is the fractional increase in diameter due to coating
% fcoat=(Dshell-Dcore)/Dcore
 warning off
 close all
 clear
 clear all

eval(['load datos.txt']);
 run=datos(:, 1);  
 
 lamso=datos(:, 2);  % reading lambda in micron
 CMDZ=datos(:, 3);  % reading radius in micron
 GSDZ=datos(:, 4);
 nr1=datos(:, 5);
 ni1=datos(:, 6); 
 fcoatZ=datos(:, 7);
 nr2=datos(:, 8);
 ni2=datos(:, 9); 

 N=size(run, 1);
% default density 1 g cm-3
 dens=1;
 % 1 corresponds to core:  
 % 2 corresponds to shell: 

  
 % Output file
 % Headers
 filecoated=fopen('zC8_TB_batch.txt', 'w'); 
 fprintf(filecoated, 'LAMBDA\text_coef\tsca_coef\tabs_coef\tssa\tasym_param\n');


 h = waitbar(0,'Running the model. Please wait...');
 for k = 1:N % run selection

   lambda=lamso(k)*1000.0;
   m1=nr1(k)+i*ni1(k);
   m2=nr2(k)+i*ni2(k);
   
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  %%%%%%%%%%%%%%%%  Soot + sulfate  %%%%%%%%%%%%%%%%%%%%%%
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
   % initialization
   ext_coef=0;
   sca_coef=0;
   asy_par1=0;
   asy_par2=0;
   abs_coef=0;   
   vol_tot=0;
   
   fcoat=fcoatZ(k);
   CMD=CMDZ(k)*2000.0;
   GSD=GSDZ(k);
   
   dlogd = min(1/10, log10(GSD)*.25);     % minimum 12 points across range;    
   limit=floor(4*log(GSD)/dlogd)*dlogd;  % integral number to cover 3.5x gsd

   
         
   
   for j = -limit:dlogd:limit % j is the core diameter in the lognormal
    Dcore=CMD*10.^j;        % core diameter
    Dshell=Dcore*(1+fcoat); % shell diameter
       % Note that 0<=x<=y;   (Mtzler, 2002).
    % Thus, the minimum shell diameter is the core diameter
    x=pi*Dcore/lambda; % Lognormal size distribution for soot (x=2*pi*r/lambda)
    y=pi*Dshell/lambda; % Sulfate diameter 
    B=Miecoated(m1,m2,x,y,1);
 %   fileouty=fopen('mie_rob.txt', 'w');
 %   fprintf(fileouty, '%.8d\t%.8d\t%.8d\t%.8d\t%.8d\t%.8d\n', B(:, 1)*lognr*dlogd, B(:, 2)*lognr*dlogd, B(:, 3)*lognr*dlogd, B(:, 4), B(:, 5), B(:, 6));
    
    Qext=B(:, 1); % Efficiency for extinction
    Qsca=B(:, 2); % Efficiency for scattering
    Qabs=B(:, 3); % Efficiency for absorption
    Qb=B(:, 4);   % Efficiency for backscattering
    g=B(:, 5);    % Asymmetry parameter
    qratio=B(:, 6); % Backscattering / scattering
    
    % Lognormal size distribution 
    % (lognormal soot + constant coating)
    lognr=zlognormalTB(Dcore, CMD, GSD); 
        
    sigma_e=pi*(Dshell/2)^2*Qext*lognr*dlogd;  % extinction coefficient value
    sigma_s=pi*(Dshell/2)^2*Qsca*lognr*dlogd;  % scattering coefficient value
    sigma_a=pi*(Dshell/2)^2*Qabs*lognr*dlogd;  % absorption coefficient value
    sigma_g=g*lognr*dlogd;     % asymmetry parameter (integrated for the size distribution)
    
    % total volume calculation
    %vol_tot=vol_tot+(pi/6)*Dcore^3*lognr*dlogd;
    vol_tot=vol_tot+(pi/6)*Dcore^3*lognr*dlogd;
    
    ext_coef=ext_coef+sigma_e;      % extinction coefficient integration
    abs_coef=abs_coef+sigma_a;      % absorption coefficient integration
    sca_coef=sca_coef+sigma_s;      % scattering coefficient integration
    asy_par1=asy_par1+g*pi*(Dshell/2)^2*Qsca*lognr*dlogd;  % asymmetry parameter integration
    asy_par2=asy_par2+pi*(Dshell/2)^2*Qsca*lognr*dlogd;
   end 
   ssa=sca_coef/ext_coef; %single scattering albedo
   asy_par=asy_par1/asy_par2;

   if abs_coef<0
     abs_coef=0;
   end
  fprintf(filecoated, '%d\t%.9d\t%.9d\t%.9d\t%d\t%d\n', lambda, ext_coef*1e3/(vol_tot*dens), sca_coef*1e3/(vol_tot*dens), abs_coef*1e3/(vol_tot*dens), ssa, asy_par);
 waitbar(k/N,h); 
 end


fclose(filecoated);
% fclose(fileouty);
close(h);
sound(10)
 
