% FUNCTION TO COMPUTE ABS COEFF
% Following Tami Bond's approach
% Roberto Pedrs pedrose@uv.es

% Type 2: 2 euro coin coating 
% The core and shell are different entities (the core is not  a "filling")
% fcoat is the fractional increase in diameter due to coating
% fcoat=(Dshell-Dcore)/Dcore
function res=zfc8(lamso, radio, sigma, mcore, mshell, fcoat, dens)

 % 1 corresponds to core:  
 % 2 corresponds to shell: 

  
 % Output file
 % Headers
 filecoated=fopen('output_zfc8.txt', 'w'); 
% fprintf(filecoated, 'LAMBDA\text_coef\tsca_coef\tabs_coef\tssa\tasym_param\n');

  % READING THE UNIT SELECION: 1 is km-1; 0 is m2/g
  eval(['load units.txt']);
  unit=units(:,1);
 
   lambda=lamso*1000.0;
   m1=mcore;
   m2=mshell;
   
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  %%%%%%%%%%%%%%%%  Soot + sulfate  %%%%%%%%%%%%%%%%%%%%%%
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
   % initialization
   ext_coef=0;
   sca_coef=0;
   asy_par1=0;
   asy_par2=0;
   abs_coef=0;   
   vol_tot=0;
   
   CMD=radio*2000.0;
   GSD=sigma;
   
   dlogd = min(1/10, log10(GSD)*.25);     % minimum 12 points across range;    
   limit=floor(4*log(GSD)/dlogd)*dlogd;  % integral number to cover 3.5x gsd
      
   
   for j = -limit:dlogd:limit % j is the core diameter in the lognormal
    Dcore=CMD*10.^j;        % core diameter
    Dshell=Dcore*(1+fcoat); % shell diameter
       % Note that 0<=x<=y;   (Mtzler, 2002).
    % Thus, the minimum shell diameter is the core diameter
    x=pi*Dcore/lambda; % Lognormal size distribution for soot (x=2*pi*r/lambda)
    y=pi*Dshell/lambda; % Sulfate diameter 
    B=Miecoated(m1,m2,x,y,1);
    
    Qext=B(:, 1); % Efficiency for extinction
    Qsca=B(:, 2); % Efficiency for scattering
    Qabs=B(:, 3); % Efficiency for absorption
    Qb=B(:, 4);   % Efficiency for backscattering
    g=B(:, 5);    % Asymmetry parameter
    qratio=B(:, 6); % Backscattering / scattering
    
    % Lognormal size distribution 
    % (lognormal soot + constant coating)
    lognr=zlognormalTB(Dcore, CMD, GSD); 
        
    sigma_e=pi*(Dshell/2)^2*Qext*lognr*dlogd;  % extinction coefficient value
    sigma_s=pi*(Dshell/2)^2*Qsca*lognr*dlogd;  % scattering coefficient value
    sigma_a=pi*(Dshell/2)^2*Qabs*lognr*dlogd;  % absorption coefficient value
    sigma_g=g*lognr*dlogd;     % asymmetry parameter (integrated for the size distribution)
    
    % total volume calculation
    %vol_tot=vol_tot+(pi/6)*Dcore^3*lognr*dlogd;
    vol_tot=vol_tot+(pi/6)*Dcore^3*lognr*dlogd;
    
    ext_coef=ext_coef+sigma_e;      % extinction coefficient integration
    abs_coef=abs_coef+sigma_a;      % absorption coefficient integration
    sca_coef=sca_coef+sigma_s;      % scattering coefficient integration
    asy_par1=asy_par1+g*pi*(Dshell/2)^2*Qsca*lognr*dlogd;  % asymmetry parameter integration
    asy_par2=asy_par2+pi*(Dshell/2)^2*Qsca*lognr*dlogd;
   end 
   ssa=sca_coef/ext_coef; %single scattering albedo
   asy_par=asy_par1/asy_par2;

   if abs_coef<0
     abs_coef=0;
   end
 % fprintf(filecoated, '%d\t%.9d\t%.9d\t%.9d\t%d\t%d\n', lambda, ext_coef*1e-9, sca_coef*1e-9, abs_coef*1e-9, ssa, asy_par);
 


if unit==1
 res=[lamso ext_coef*1e-9 sca_coef*1e-9 abs_coef*1e-9 ssa asy_par];
elseif unit==0
 res=[lamso ext_coef*1e3/(vol_tot*dens) sca_coef*1e3/(vol_tot*dens) abs_coef*1e3/(vol_tot*dens) ssa asy_par];
fprintf(filecoated, '%d\t%.9d\t%.9d\t%.9d\t%d\t%d\n', res(1), res(2), res(3), res(4), res(5), res(6));
end
 
fclose(filecoated);