% PURE SOOT
% C8_pure_TB.m file
% Pure component

% 9 April 2013
% Following Tami Bond's approach
% Roberto Pedrs pedrose@uv.es

function respure=zfc8_pure(lamso, radio, sigma, mcore, dens)


 % READING THE UNIT SELECION: 1 is km-1; 0 is m2/g
  eval(['load units.txt']);
  unit=units(:,1);

 lambda=lamso*1000.0;
 m=mcore;
 
 CMD=radio*2000.0;
 GSD=sigma;

  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  %%%%%%%%%%%%%%%%%%%    PURE SOOT  %%%%%%%%%%%%%%%%%%%%%%
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
   % initialization
   ext_coef=0;
   sca_coef=0;
   asy_par1=0;
   asy_par2=0;
   abs_coef=0;   
   vol_tot=0;
   
   dlogd = min(1/10, log10(GSD)*.25);     % minimum 12 points across range;    
   limit=floor(4*log(GSD)/dlogd)*dlogd;  % integral number to cover 3.5x gsd

   
   for j = -limit:dlogd:limit % j is the core diameter in the lognormal
    Dcore=CMD*10^j;        % core diameter
       % Note that 0<=x<=y;   (Mtzler, 2002).
    % Thus, the minimum shell diameter is the core diameter
    x=pi*Dcore./lambda; % Lognormal size distribution for soot (x=2*pi*r/lambda)
    B=Mie(m,x);
    
    Qext=B(:, 1); % Efficiency for extinction
    Qsca=B(:, 2); % Efficiency for scattering
    Qabs=B(:, 3); % Efficiency for absorption
    Qb=B(:, 4);   % Efficiency for backscattering
    g=B(:, 5);    % Asymmetry parameter
    qratio=B(:, 6); % Backscattering / scattering
    
    % Lognormal size distribution 
    % (lognormal soot + constant coating)
    lognr=zlognormalTB(Dcore, CMD, GSD); 
        
    sigma_e=pi*(Dcore/2)^2*Qext*lognr*dlogd;  % extinction coefficient value
    sigma_s=pi*(Dcore/2)^2*Qsca*lognr*dlogd;  % scattering coefficient value
    sigma_a=pi*(Dcore/2)^2*Qabs*lognr*dlogd;  % absorption coefficient value
    sigma_g=g*lognr*dlogd;     % asymmetry parameter (integrated for the size distribution)
    
    % total volume calculation
    vol_tot=vol_tot+(pi/6)*Dcore^3*lognr*dlogd;
    
    ext_coef=ext_coef+sigma_e;      % extinction coefficient integration
    abs_coef=abs_coef+sigma_a;      % absorption coefficient integration
    sca_coef=sca_coef+sigma_s;      % scattering coefficient integration
    asy_par1=asy_par1+g*pi*(Dcore/2)^2*Qsca*lognr*dlogd;  % asymmetry parameter integration
    asy_par2=asy_par2+pi*(Dcore/2)^2*Qsca*lognr*dlogd;
   end 
   ssa=sca_coef/ext_coef; %single scattering albedo
   asy_par=asy_par1/asy_par2;

   if abs_coef<0
     abs_coef=0;
   end
  % fprintf(filepure, '%d\t%d\t%d\t%d\t%d\t%d\n', lambda, 1e3*ext_coef/(vol_tot*dens), 1e3*sca_coef/(vol_tot*dens), 1e3*abs_coef/(vol_tot*dens), ssa, asy_par);
  % fprintf(filepure, '%d\t%d\t%d\n', CMD, CMD*pi/lambda, 1e3*abs_coef/vol_tot);


%fclose(filepure);
%fclose all

sound(10)
 
unit=0;

if unit==1
 respure=[lamso ext_coef*1e-9 sca_coef*1e-9 abs_coef*1e-9 ssa asy_par];
elseif unit==0
 respure=[lamso ext_coef*1e3/(vol_tot*dens) sca_coef*1e3/(vol_tot*dens) abs_coef*1e3/(vol_tot*dens) ssa asy_par];
end

fileout=fopen('out_zfc8_pure.txt', 'w');
fprintf(fileout, '%d\t%d\t%d\t%d\t%d\t%d\n', respure(1), respure(2), respure(3), respure(4), respure(5), respure(6));
fclose(fileout);
