% LogNormal(diam, cmd, gsd) returns dN/dlogD given range of diam.
% Note that gsd will be transformed to log(gsd) 
function df=LogNormal(diam, mu, gsd)

if nargin<1
    help LogNormal
    return
end
loggsd = log10(gsd);

df = exp(- ((log10(diam/mu)).^2)./(2*loggsd^2)) / (sqrt(2*pi) * loggsd);
return

