%
% --------------------------------------
% COLORLAB (version 3.0)
% Jesus Malo            jesus.malo@uv.es 
% Maria Jose Luque      maria.j.luque@uv.es
%
% (c) Universitat de Valencia. 1997-2016
% --------------------------------------
%
% Load basic colorimetric data: (first thing to do!)
% -----------------------------
% 
%    startcol - Load the necessary information to start working
%               (1) Primaries of the Tristimulus Space (space may be changed later) 
%               (2) Associated Color Matching Functions 
%               (3) Associated Trichromatic Units
%               (4) Generic display calibration data (calibration may be changed later)
%
% CLASSIC COLORIMETRY: from Radiances to Tristimulus Vectors
% --------------------
%    
%    ILLUMINANTS AND REFLECTANCE:
%
%    defillu - graphic definition of illuminants
%    defrefl - graphic definition of spectral reflectances/transmitances
%    saveillu - saves illuminants in COLORLAB format
%    saverefl - saves reflectance in COLORLAB format
%    loadillu - loads illuminants in COLORLAB format
%    loadrefl - loads reflectance in COLORLAB format
%
%    spec2tri - from spectra to tristimulus vectors
%    tri2spec - from tristimulus vectors to spectra (approx. solution)
%
%    COMPUTATIONS IN A TRISTIMULUS SPACE:
%
%    defcolor - graphic definition of colors
%    defcroma - graphic definition of chromaticities
%    savecol - saves a set of colors in COLORLAB format
%    loadcol - loads a set of colors in COLORLAB format
%
%    tri2coor - compute chromatic coordinates and luminance from tristimulus values
%    coor2tri - compute chromatic coordinates and luminance from tristimulus values
%
%    coor2lp - compute dominant wavelength, purity and luminance from chromatic coordinates and luminance.
%    lp2coor - computes [t1 t2 Y] from [lambda_d P Y]
% 
%    colordgm - plots colors in the chromatic diagram. 
%    colorspc - plots colors in the tristimulus space
%
%    CHANGE OF BASIS:
%
%    defsys - graphic definition of a new color system
%    defsysm - defines a new color system from (manually) given information.
%    savesysm - saves the data of a color basis to a (manually) given file
%    loadsys - load the data of a color basis using a dialog box
%    loadsysm - load the data of a color basis from manually introduced path
%    chngmtx - computes the change-of-basis matrix that relates the systems P and P'
%    newbasis - represents a set of tristimulus vectors in a new basis (applies matrix)
%    newconst - computes the constants that define a new color basis
%
% COLOR APPEARANCE MODELS: beyond linear tristimulus colorimetry (adaptation and constancy)
% -----------------------
%
%    xyz2lab - computes the lightness, L*, and the chromatic coordinates a* and b* in CIELAB from CIE XYZ tristimuli
%    lab2xyz - inverse of the above
%    lab2perc - computes the computes the lightness, chroma and hue angle fom CIELAB
%    perc2lab - inverse of the above
%    xyz2luv - computes the lightness, L*, and the chromatic coordinates u* and v* in CIELUV from CIE XYZ tristimuli
%    luv2xyz - inverse of the above
%    luv2perc - computes the computes the lightness, chroma and hue angle from CIELUV
%    perc2luv - inverse of the above
%
%    xyz2con - transforms XYZ tristimulus values into LMS cone-spaces
%    con2xyz - inverse of the above
%    con2atd - transforms LMS responses to opponent channels
%    atd2con - inverse of the above
%    atd2perc - computes Brightness (B), Hue (H) and Saturation (S) from opponent-stage descriptors
%    perc2atd - inverse of the above
%
%    ciecam97 - computes the ciecam97 transform (similar to CIECAM 2000) from xyY
%    cam97inv - inverse of the above
%
%    xyz2svf - computes the value V and the two coordinates F1 and F2 in the SVF space
%    svf2xyz - inverse of the above
%    
%    xyz2rlab - computes the coordenates L,a,b in RLab space (and C, H)
%    rlab2xyz - inverse of the above
%
%    xyz2llab - computes the coordenates L,a,b in LLab space (and C, H)
%    llab2xyz - inverse of the above
%    
%
% CALIBRATED COLOR DISPLAY: from Tristimulus Vectors to images in the display 
% -------------------------
%
%    calibrat - Procedure for manual monitor calibration (requires photo-colorimeter)
%    savemon - saves the monitor calibration data to a (manually) given file
%    loadmon - opens a dialog box to load the calibration data of the monitor. 
%  
%    tri2val - computes digital values, n, from tristimulus vectors, T (here there is information loss)  
%    val2tri - inverse of the above (no information loss)
%
%    true2pal - generates the indexed image and the palette from the true color image
%    pal2true - inverse of the above
%
% COLORLAB DATABASES:
% ------------------- 
%    
%    Standard CIE Iluminants (see loadillu.m) 
%
%    Munsell Reflectance Database (see loadrefl.m)
%
%    McAdam Ellipses (see loadrefl.m)
%
%    Hyperspectral images (geometry is neglected -lambertian reflectance in each pixel is assumed-)
%    (images were computed using tri2spec.m)
%
%    Visit http://isp.uv.es/data_color.htm 
%    for calibrated pictures of real scenes under calibrated illuminants
%
% Demos
% -----
%
%    dim_percept_color - Demo on the 6 (not 3!) perceptual dimensions of color:
%                        (1) Brightness   Q        
%                        (2) Hue          h
%                        (3) Colorfulness M
%                        (4) Lightness    J
%                        (5) Chroma       C
%                        (6) Saturation   S
%