%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%
% Descriptores absolutos (siempre validos -para aislados y relacionados-)
% -----------------------------------------------------------------------
%
%  Son tres:
%
%    - Luminosidad (Q)
%    - Tono (h)
%    - Colorido (M)


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%   - Luminosidad (Brigthness o Q): 
%      Atributo perceptual segun el cual un estimulo parece emitir 
%      mas o menos 'cantidad de luz'
%   
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

tam_pant=get(0,'ScreenSize');
ancho_pant=tam_pant(3);
alto_pant=tam_pant(4)-40;

% Carguemos el Sistema CIE XYZ y calibrado para monitor estandard
% [T_l,Yw,Msx]=loadsys;
% [tm,a,g]=loadmon(Msx);

p = which('ciexyz.mat');
[T_l,Yw,Msx]=loadsysm(p);
p = which('std_crt.mat');
[tm,a,g]=loadmonm(p,Msx);

% EVID. Q DEPENDE DE LA RADIANCIA...
%
% Generemos 10 muestras cromaticas de radiancia creciente (escalando su
% reflectancia o escalando el espectro del iluminante... etc, en particular, 
% aqui prmero escalamos la luminancia manteniendo coord cromaticas y luego 
% buscaremos las reflectancias apropiadas para generar esos colores con un iluminante apropiado).

t=[0.3 0.45];
Y=linspace(5,100,10);
T=coor2tri([t(ones(10,1),:) Y'],Yw);

% Y las ponemos sobre un fondo 'gris' de baja radiancia

tf=[0.333 0.333];
Yf=20;
Tf=coor2tri([tf Yf],Yw);

% El conjunto de colores que queremos generar es [T;Tf], 
% Busquemos estas reflectancias en el conjunto munsell.mat

load munsell.mat
% Carga iluminante D65
p=which('iluminan.d65');
esp=loadilum(p,250,1,10,T_l,Yw);
% Selecciona las reflectancias que (aprox) nos dan los colores que buscamos
RT=tri2spec([T;Tf],reflec,esp,250,T_l,Yw);
[T,RR]=spec2tri(T_l,10,RT,esp,250,Yw);

% Su caracterizacion dependiente del dispositivo (niveles digitales), es:

[n,saturat,Tn]=tri2val(T,Yw,tm,a,g,8,0);

% Para dibujarlo todo...

im=11*ones(3,10+9+2);
im(2,2:2:20)=1:10;

% figure(2),
% axis([0 1 0 1]),axis('off'),text(0,0.7,'LUMINOSIDAD (1/4): Radiancia','FontSize',14);
% disp(' ')
% disp(' ')
% disp(' Press the INTRO key to continue!')
% disp(' ')
% disp(' ')
% lala = input(' ');,close(2)

disp(' ')
disp(' BRIGHTNESS (1/4): Radiance')
disp(' Press the INTRO key to continue!')
disp(' ')
disp(' ')
lala = input(' ');

figure(1),plot(RR(:,1),RR(:,2:11)),axis([380 770 0 1.8e-3]),xlabel('\lambda (nm)'),ylabel('Spectral Radiance (W/m^2 nm str)')
set(1,'Position',[2*ancho_pant/3 alto_pant/2 ancho_pant/3 0.9*alto_pant/2])
figure(2),colormap(n),image(im),axis('off')
set(2,'Position',[2*ancho_pant/3 40 ancho_pant/3 0.9*alto_pant/2])

% PERO... IGUALDAD EN RADIANCIA NO IMPLICA IGUALDAD DE Q

% figure(3),
% axis([0 1 0 1]),axis('off'),text(0,0.7,'LUMINOSIDAD (2/4): Luminancia','FontSize',14);
% disp(' ')
% disp(' ')
% disp(' Press the INTRO key to continue!')
% disp(' ')
% disp(' ')
% lala = input(' ');

disp(' ')
disp(' BRIGHTNESS (2/4): Luminance')
disp(' Press the INTRO key to continue!')
disp(' ')
disp(' ')
lala = input(' ');


% Dominio de lambdas
l=380:770;
l=(380:770)';

% Estimulos (reflectancias)
l0=460:10:660;
anch=5;
for i=1:length(l0),r(:,i)=0.06*ones(length(l),1)+0.94*exp(-(l-l0(i)).^2/anch^2);end
r(:,length(l0)+1)=1*sum(r(:,1))*ones(length(l),1)/length(l);
figure(3),plot(l,r),axis([380 770 0 1.1]),xlabel('\lambda (nm)'),ylabel('Reflectance')
set(3,'Position',[2*ancho_pant/3 alto_pant/2 ancho_pant/3 0.9*alto_pant/2])
R=[l r];

% Iluminante
S=[l ones(length(l),1)];

[T,RR]=spec2tri(T_l,1,R,S,600,Yw);
%figure(3),colordgm(T,1,T_l,Yw);

[n,saturat,Tn]=tri2val(T,Yw,tm,a,g,8,0);

ll=length(T(:,1));
im=ll*ones(3,2*(ll-1)+1);
im(2,2:2:2*(ll-1))=1:ll-1;
TTT=T;
%figure(4),colordgm(Tn,1,T_l,Yw);

figure(4),colormap(n),image(im),saturat;
set(4,'Position',[1*ancho_pant/3 40 ancho_pant/3 0.9*alto_pant/2])
% disp(' ')
% disp(' ')
% disp(' Press the INTRO key to continue!')
% disp(' ')
% disp(' ')
% lala = input(' ');

figure(5),plot(T_l(:,1),T_l(:,3)),xlabel('\lambda  (nm)'),ylabel('V_\lambda')
axis([380 770 0 1.1])
set(5,'Position',[1*ancho_pant/3 alto_pant/2 ancho_pant/3 0.9*alto_pant/2])
% disp(' ')
% disp(' ')
% disp(' Press the INTRO key to continue!')
% disp(' ')
% disp(' ')
% lala = input(' ');

% IGUALDAD EN LUMINANCIA TAMPOCO IMPLICA IGUALDAD EN LUMINOSIDAD!!
%
% Un ejemplo de que Q depende de la cromaticidad aun igualando luminancias
% podemos tenerlo generando la serie de la figura 4 (pseudoespectrales) 
% con luminancia constante (multiplicando cada reflectancia por la inversa 
% de su luminancia, y multiplicando por un factor constante).
%

% figure(5),
% axis([0 1 0 1]),axis('off'),text(0,0.7,'LUMINOSIDAD (3/4): Efectos cromaticos','FontSize',14);
% disp(' ')
% disp(' ')
% disp(' Press the INTRO key to continue!')
% disp(' ')
% disp(' ')
% lala = input(' ');

disp(' ')
disp(' BRIGHTNESS (3/4): Chromatic effects')
disp(' Press the INTRO key to continue!')
disp(' ')
disp(' ')
lala = input(' ');


% Tomamos los valores triestimulo previos:
T=TTT;

% Y les metemos la misma luminancia
t2=tri2coor(T,Yw);
t=[t2(:,1:2) mean(t2(:,3))*ones(length(t2(:,3)),1)];
T=coor2tri(t,Yw);

rr=r;
for i=2:length(l0)+1,rr(:,i)=0.7*r(:,i)*mean(t2(:,3))/t2(i-1,3);end
figure(6),plot(l,rr(:,2:end)),axis([380 770 0 1.1]),xlabel('\lambda (nm)'),ylabel('Reflectance')
set(6,'Position',[2*ancho_pant/3 alto_pant/2 ancho_pant/3 0.9*alto_pant/2])


[n,saturat,Tn]=tri2val(T,Yw,tm,a,g,8,0);

ll=length(T(:,1));
im=ll*ones(3,2*(ll-1)+1);
im(2,2:2:2*(ll-1))=1:ll-1;

%figure(4),colordgm(Tn,1,T_l,Yw);

figure(5),colormap(n),image(im),saturat;
set(5,'Position',[0*ancho_pant/3 alto_pant/2 ancho_pant/3 0.9*alto_pant/2])
% disp(' ')
% disp(' ')
% disp(' Press the INTRO key to continue!')
% disp(' ')
% disp(' ')
% lala = input(' ');

% PERO Q TAMBIEN DEPENDE DE OTRAS COSAS, P.EJ. ENTORNO ESPACIO-TEMPORAL, CROMATICIDAD...
%
% Genaremos 2 muestras amarillas iguales y las situamos en entornos grises diferentes
% (efecto del entorno).
% En la misma escena, colocamos 2 muestras azules con diferente luminancia
% sobre el gris claro (efecto de la energia y la cromaticidad).

% figure(6),
% axis([0 1 0 1]),axis('off'),text(0,0.7,'LUMINOSIDAD (4/4): Efectos espaciales y cromaticos','FontSize',14);
% disp(' ')
% disp(' ')
% disp(' Press the INTRO key to continue!')
% disp(' ')
% disp(' ')
% lala = input(' ');

disp(' ')
disp(' BRIGHTNESS (4/4): Spatial and Chromatic efects')
disp(' Press the INTRO key to continue!')
disp(' ')
disp(' ')
lala = input(' ');


t=[0.5 0.5;0.25 0.15];
Y=[50 50 50 30];
T=coor2tri([t([ones(2,1);2*ones(2,1)],:) Y'],Yw);

% Los dos fondos 'grises' son:

tf=[0.333 0.333];
Yf=[0 150];
Tf=coor2tri([tf(ones(2,1),:) Yf'],Yw);

% El conjunto de colores que queremos generar es [T;Tf], y su caracterizacion
% dependiente del dispositivo (niveles digitales), es:

[n,saturat,Tn]=tri2val([T;Tf],Yw,tm,a,g,8,0);

% Para dibujarlo todo...

im=6*ones(6,6);
im(1:3,1:3)=5*ones(3,3);
im(2,2)=1;
im(2,5)=2;
im(5,2)=3;
im(5,5)=4;

figure(6),colormap(n),image(im),axis('off')
set(6,'Position',[0*ancho_pant/3 40 ancho_pant/3 0.9*alto_pant/2])

disp(' ')
disp(' ')
disp(' Press the INTRO key to continue!')
disp(' ')
disp(' ')
lala = input(' ');
close all

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%   - Tono (hue o h): 
%      Atributo perceptual segun el cual un estimulo se puede numbrar 
%      como rojo, verde, amarillo, azul o combinaciones de dos de estos 
%      cuatro nombres, p.ej. rojo-amarillento...
%
%     NOTA: un color acromatico es aquel al que no se le puede asignar
%     ninguno de los nombres (no tiene tono) y un color cromatico es el que
%     si tiene tono
%   
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% % Carguemos el XYZ
% [T_l,Yw,Msx]=loadsys;
% [tm,a,g]=loadmon(Msx);

% EVID. h DEPENDE DE LA FORMA DE LA RADIANCIA ESPECTRAL...
%
% Aqui simularemos eso con 8 estimulos de diferentes longitudes de onda
% dominantes...
%
% MODIFIC. posterior: nada de simular, vamos a buscar las reflectancias que
% toquen para generar una escena fisica (con teselas reflectantes) y asi
% generar un buen ejemplo de la dependencia del tono con el entorno a base
% de cambiar el iluminante...

% figure(6),
% axis([0 1 0 1]),axis('off'),text(0,0.7,'TONO (1/3): Espectro','FontSize',14);
% disp(' ')
% disp(' ')
% disp(' Press the INTRO key to continue!')
% disp(' ')
% disp(' ')
% lala = input(' ');(0.1),close(6)

disp(' ')
disp(' ')
disp(' HUE (1/3): Hue = shape of spectrum?')
disp(' Press the INTRO key to continue!')
disp(' ')
disp(' ')

lala = input(' ');

% Primero unos colores bonitos para esto:

%        R     R_Y    Y   Y_G    G    G_B    B    B_R                     

l_dom=[  596   580   570   558   534   491   460   -540];
p_c  =[  0.6  0.55  0.65  0.5   0.4   0.4   0.5    0.35];
lum  =[  40    75    90    70    50    40    30     40];

lpy_crom=[l_dom' p_c' lum'];

t=lp2coor(lpy_crom,1,T_l,Yw);
T=coor2tri(t,Yw);

% Dos estimulos grises uno de los cuales hace de fondo

tf=[0.333 0.333];
Yf=[70 90];
Tf=coor2tri([tf(ones(2,1),:) Yf'],Yw);

% Ahora busco las reflectancias que corresponden (iluminandolas con un blanco -D65-)

% Carga un conjunto (grande) de reflectancias
load munsell.mat
% Carga iluminante D65
esp=loadilum('iluminan.d65',250,1,10,T_l,Yw);
% Selecciona las reflectancias que (aprox) nos dan los colores que buscamos
RT=tri2spec([T;Tf],reflec,esp,250,T_l,Yw);
[T,RR]=spec2tri(T_l,10,RT,esp,250,Yw);

% El conjunto de colores que queremos generar es [T;Tf], y su caracterizacion
% dependiente del dispositivo (niveles digitales), es:

[n1,saturat,Tn]=tri2val(T,Yw,tm,a,g,8,0);

% Para dibujarlo todo...

im=10*ones(9,9);
im(3,3:2:7)=[5 4 3];
im(5,3:2:7)=[6 9 2];
im(7,3:2:7)=[7 8 1];

figure(6),
subplot(331),tt=plot(RR(:,1),RR(:,6));axis([380 700 0 1.8e-3]),%xlabel('\lambda (nm)'),ylabel('Radiancia (W / m^2 str nm)')
set(tt(1),'Color',n1(5,:),'LineWidth',2);
subplot(332),tt=plot(RR(:,1),RR(:,5));axis([380 700 0 1.8e-3]),%xlabel('\lambda (nm)'),ylabel('Radiancia (W / m^2 str nm)')
set(tt(1),'Color',n1(4,:),'LineWidth',2);
subplot(333),tt=plot(RR(:,1),RR(:,4));axis([380 700 0 1.8e-3]),%xlabel('\lambda (nm)'),ylabel('Radiancia (W / m^2 str nm)')
set(tt(1),'Color',n1(3,:),'LineWidth',2);
subplot(334),tt=plot(RR(:,1),RR(:,7));axis([380 700 0 1.8e-3]),%xlabel('\lambda (nm)'),ylabel('Radiancia (W / m^2 str nm)')
set(tt(1),'Color',n1(6,:),'LineWidth',2);
subplot(335),tt=plot(RR(:,1),RR(:,10));axis([380 700 0 1.8e-3]),%xlabel('\lambda (nm)'),ylabel('Radiancia (W / m^2 str nm)')
set(tt(1),'Color',n1(9,:),'LineWidth',2);
subplot(336),tt=plot(RR(:,1),RR(:,3));axis([380 700 0 1.8e-3]),%xlabel('\lambda (nm)'),ylabel('Radiancia (W / m^2 str nm)')
set(tt(1),'Color',n1(2,:),'LineWidth',2);
subplot(337),tt=plot(RR(:,1),RR(:,8));axis([380 700 0 1.8e-3]),%xlabel('\lambda (nm)'),ylabel('Radiancia (W / m^2 str nm)')
set(tt(1),'Color',n1(7,:),'LineWidth',2);
subplot(338),tt=plot(RR(:,1),RR(:,9));axis([380 700 0 1.8e-3]),%xlabel('\lambda (nm)'),ylabel('Radiancia (W / m^2 str nm)')
set(tt(1),'Color',n1(8,:),'LineWidth',2);
subplot(339),tt=plot(RR(:,1),RR(:,2));axis([380 700 0 1.8e-3]),%xlabel('\lambda (nm)'),ylabel('Radiancia (W / m^2 str nm)')
set(tt(1),'Color',n1(1,:),'LineWidth',2);
set(6,'Position',[1*ancho_pant/3 40 ancho_pant/3 0.9*alto_pant/2],'MenuBar','none')

figure(7),colormap(n1),image(im),axis('off'),
set(7,'Position',[1*ancho_pant/3 alto_pant/2 ancho_pant/3 0.9*alto_pant/2],'Color',[n1(end,:)],'MenuBar','Figure')
% disp(' ')
% disp(' ')
% disp(' Press the INTRO key to continue!')
% disp(' ')
% disp(' ')
% lala = input(' ');

% PERO NO SOLO DE ESO!!
%
% Ejempl 1. Ahora cambiamos el iluminante (cambiamos la forma espectral) y 'sorprendentemente', 
% el tono se mantiene (aprox) -esto es constancia del color-

% figure(8),
% axis([0 1 0 1]),axis('off'),text(0,0.7,'TONO (2/3): Adaptacion','FontSize',14);
% disp(' ')
% disp(' ')
% disp(' Press the INTRO key to continue!')
% disp(' ')
% disp(' ')
% lala = input(' ');

disp(' ')
disp(' HUE (2/3): Adaptation')
disp(' Press the INTRO key to continue!')
disp(' ')
disp(' ')
lala = input(' ');


%esp2=loadilum('c:/rutinas/matlab_jesus/colorlab/colordat/illumin/unamaril.mat',250,1,10,T_l,Yw);
esp2=loadilum('iluminan.a',250,1,10,T_l,Yw);
esp2(:,2)=esp2(:,2)+0.1*mean(esp2(:,2))*ones(length(esp2(:,2)),1);
% Selecciona las reflectancias que (aprox) nos dan los colores que buscamos
[T2,RR]=spec2tri(T_l,10,RT,esp2,250,Yw);

% El conjunto de colores que queremos generar es [T;Tf], y su caracterizacion
% dependiente del dispositivo (niveles digitales), es:

[n2,saturat,Tn]=tri2val(T2,Yw,tm,a,g,8,0);

% Para dibujarlo todo...
figure(8),
subplot(331),tt=plot(RR(:,1),RR(:,6));axis([380 700 0 1.8e-3]),%xlabel('\lambda (nm)'),ylabel('Radiancia (W / m^2 str nm)')
set(tt(1),'Color',n1(5,:),'LineWidth',2);
subplot(332),tt=plot(RR(:,1),RR(:,5));axis([380 700 0 1.8e-3]),%xlabel('\lambda (nm)'),ylabel('Radiancia (W / m^2 str nm)')
set(tt(1),'Color',n1(4,:),'LineWidth',2);
subplot(333),tt=plot(RR(:,1),RR(:,4));axis([380 700 0 1.8e-3]),%xlabel('\lambda (nm)'),ylabel('Radiancia (W / m^2 str nm)')
set(tt(1),'Color',n1(3,:),'LineWidth',2);
subplot(334),tt=plot(RR(:,1),RR(:,7));axis([380 700 0 1.8e-3]),%xlabel('\lambda (nm)'),ylabel('Radiancia (W / m^2 str nm)')
set(tt(1),'Color',n1(6,:),'LineWidth',2);
subplot(335),tt=plot(RR(:,1),RR(:,10));axis([380 700 0 1.8e-3]),%xlabel('\lambda (nm)'),ylabel('Radiancia (W / m^2 str nm)')
set(tt(1),'Color',n1(9,:),'LineWidth',2);
subplot(336),tt=plot(RR(:,1),RR(:,3));axis([380 700 0 1.8e-3]),%xlabel('\lambda (nm)'),ylabel('Radiancia (W / m^2 str nm)')
set(tt(1),'Color',n1(2,:),'LineWidth',2);
subplot(337),tt=plot(RR(:,1),RR(:,8));axis([380 700 0 1.8e-3]),%xlabel('\lambda (nm)'),ylabel('Radiancia (W / m^2 str nm)')
set(tt(1),'Color',n1(7,:),'LineWidth',2);
subplot(338),tt=plot(RR(:,1),RR(:,9));axis([380 700 0 1.8e-3]),%xlabel('\lambda (nm)'),ylabel('Radiancia (W / m^2 str nm)')
set(tt(1),'Color',n1(8,:),'LineWidth',2);
subplot(339),tt=plot(RR(:,1),RR(:,2));axis([380 700 0 1.8e-3]),%xlabel('\lambda (nm)'),ylabel('Radiancia (W / m^2 str nm)')
set(tt(1),'Color',n1(1,:),'LineWidth',2);
set(8,'Position',[2*ancho_pant/3 40 ancho_pant/3 0.9*alto_pant/2],'MenuBar','none')

%figure(7),colormap(n1),image(im),axis('off'),

figure(9),colormap(n2),image(im),axis('off'),
set(9,'Position',[2*ancho_pant/3 alto_pant/2 ancho_pant/3 0.9*alto_pant/2],'Color',n2(end,:),'MenuBar','Figure')
% disp(' ')
% disp(' ')
% disp(' Press the INTRO key to continue!')
% disp(' ')
% disp(' ')
% lala = input(' ');

% PERO NO SOLO DE ESO!!
%
% Ejempl 2. Si ahora 'magicamente' metemos una de las muestras 
% de la escena 1 en la escena 2, cambiara su tono...

% figure(10),
% axis([0 1 0 1]),axis('off'),text(0,0.7,'TONO (3/3): Induccion','FontSize',14);
% disp(' ')
% disp(' ')
% disp(' Press the INTRO key to continue!')
% disp(' ')
% disp(' ')
% lala = input(' ');

disp(' ')
disp(' HUE (3/3): Induction')
disp(' Press the INTRO key to continue!')
disp(' ')
disp(' ')
lala = input(' ');

figure(10),colormap([n2(1:8,:);n1(9,:);n2(10,:)]),image(im),axis('off'),
set(10,'Position',[0*ancho_pant/3 alto_pant/2 ancho_pant/3 0.9*alto_pant/2],'MenuBar','Figure','Color',n2(end,:))

figure(11),set(11,'Color',n1(end,:),'MenuBar','none')
figure(12),set(12,'Color',n1(end,:),'MenuBar','none')
figure(13),set(13,'Color',n1(end,:),'MenuBar','none')
disp(' ')
disp(' ')
disp(' Press the INTRO key to continue!')
disp(' ')
disp(' ')
lala = input(' ');
close all

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%   - Colorido (Colorfulness o M): 
%      Atributo perceptual segun el cual un estimulo parece mas o menos 
%      cromatico
%   
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% % Carguemos el XYZ
% [T_l,Yw,Msx]=loadsys;
% [tm,a,g]=loadmon(Msx);

% EVID. M DEPENDE DE 'LO PLANA' QUE SEA LA RADIANCIA ESPECTRAL...
%
% Aqui simularemos eso con 10 estimulos de diferentes purezas
% colorimetricas de la misma luminancia

% figure(11),
% axis([0 1 0 1]),axis('off'),text(0,0.7,'COLORIDO: Espectro y luminancia','FontSize',14);
% disp(' ')
% disp(' ')
% disp(' Press the INTRO key to continue!')
% disp(' ')
% disp(' ')
% lala = input(' ');

disp(' ')
disp(' COLORFULNESS: Spectrum variance and luminance')
disp(' Press the INTRO key to continue!')
disp(' ')
disp(' ')
lala = input(' ');

 l=568;
 Y=60;
 pc=linspace(0.2,0.85,10);
 lpY=[l*ones(10,1) pc' Y*ones(10,1)];
 t=lp2coor(lpY,2,T_l,Yw);
 T=coor2tri(t,Yw);
 Tw=val2tri([1 1 1],Yw,tm,a,g);
 [n,saturat,XYZn]=tri2val([T;Tw],Yw,tm,a,g,8);
 
% im=11*ones(3,21);im(2,2:2:20)=1:10;
% 
% figure(4),colormap(n),image(im),axis('off')


%  NO OBSTANTE, EL COLORIDO TAMBIEN DEPENDE DEL NIVEL DE RADIANCIA
%  (hace falta correr el ejemplo anterior)
%
l=568;
Y=20;
pc=linspace(0.2,0.85,10);
lpY=[l*ones(10,1) pc' Y*ones(10,1)];
t=lp2coor(lpY,2,T_l,Yw);
T1=coor2tri(t,Yw);
T2=T;
Y=100;
pc=linspace(0.2,0.85,10);
lpY=[l*ones(10,1) pc' Y*ones(10,1)];
t=lp2coor(lpY,2,T_l,Yw);
T3=coor2tri(t,Yw);
Y=125;
pc=linspace(0.2,0.85,10);
lpY=[l*ones(10,1) pc' Y*ones(10,1)];
t=lp2coor(lpY,2,T_l,Yw);
T4=coor2tri(t,Yw);
Y=150;
pc=linspace(0.2,0.85,10);
lpY=[l*ones(10,1) pc' Y*ones(10,1)];
t=lp2coor(lpY,2,T_l,Yw);
T5=coor2tri(t,Yw);


[n,saturat,XYZn]=tri2val([T1;T2;T3;T4;T5;Tw],Yw,tm,a,g,8);

im=51*ones(11,21);
im(2,2:2:20)=1:10;
im(4,2:2:20)=11:20;
im(6,2:2:20)=21:30;
im(8,2:2:20)=31:40;
im(10,2:2:20)=41:50;

figure(11),colormap(n),image(im),axis('off')
%set(11,'Position',[1*ancho_pant/3 alto_pant/2 ancho_pant/3 0.9*alto_pant/2])
disp(' ')
disp(' ')
disp(' Press the INTRO key to continue to LIGTHNESS!')
disp(' ')
disp(' ')
lala = input(' ');
%close all

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%
% Descriptores Relativos que involucran comparaciones (con ellos o con el entorno)
% -------------------------------------------------------------------------
%
%  Son tres:
%
%    - Claridad (J)   (comparacion con entorno)
%    - Saturacion (S) (auto-comparacion)
%    - Croma (C)      (comparacion con entorno)
%
%    (no hay ningun atributo perceptual que involucre comparaciones de tono 
%     con una referencia -la constancia del color con cambio de iluminante 
%     en una escena compleja es un ejemplo de la 'dependencia' de un descriptor 
%     absoluto, el tono, depende del entorno, como en el caso de la luminosidad-)
%
%     Comentario sobre independencia de los atributos     
%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%   - Claridad (Lightness o J): 
%
%      Cutre: Luminosidad de una muestra juzgada en comparacion con la luminosidad
%             del entorno.
%
%      Buena: Luminosidad de una muestra juzgada en comparacion con la luminosidad
%             de un estimulo igualmente iluminado que se perciba como
%             acromatico y muy luminoso.
%   
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  Incrementando la reflectancia de las muestras sin variar 
%  la iluminacion se incrementa Q y tambien crece J 
%  (en realidad manteniendo el fondo constante Q y J son proporcionales)

% figure(12),
% axis([0 1 0 1]),axis('off'),text(0,0.7,'CLARIDAD (1/3): crece con reflectancia','FontSize',14);
% disp(' ')
% disp(' ')
% disp(' Press the INTRO key to continue!')
% disp(' ')
% disp(' ')
% lala = input(' ');

disp(' ')
disp(' LIGHTNESS (1/3): increases with reflectance')
disp(' Press the INTRO key to continue!')
disp(' ')
disp(' ')
lala = input(' ');

lum_fondo=1.2*[10 20 40 80]; % Fondo claro
%lum_fondo=1.2*[5 10 20 40]; % Fondo oscuro
crom_fondo=[0.3333 0.3333];  % Fondo acromatico
tYfondos=[crom_fondo(ones(4,1),:) lum_fondo'];
Tfondos=coor2tri(tYfondos,Yw);


% Genero 8*3*4 estimulos cromaticos con 8 lambdas 
% dominantes del rojo pasando por el verde y hasta el purpura 
% [596 587 566 534 491 465 -568 -514] nm, 3 purezas colorimetricas 
% [0.05 0.15 0.25] y 4 luminancias [7.5 15 30 60] cd/m2
% Y adamas genero 4 estimulos acromaticos con las luminancias anteriores.


l_dom=[596 587 566 534 491 465 -568 -514];
p_c=1.2*[0.05 0.15 0.25];
lum=1.2*[7.5 15 30 60];
% Tipo de pureza 1=pureza_excit, 2=pureza_colorim
tipo=1; 


lpy_crom_l1=[l_dom' p_c(1)*ones(8,1) lum(1)*ones(8,1);l_dom' p_c(2)*ones(8,1) lum(1)*ones(8,1);l_dom' p_c(3)*ones(8,1) lum(1)*ones(8,1)];
lpy_crom_l2=[l_dom' p_c(1)*ones(8,1) lum(2)*ones(8,1);l_dom' p_c(2)*ones(8,1) lum(2)*ones(8,1);l_dom' p_c(3)*ones(8,1) lum(2)*ones(8,1)];
lpy_crom_l3=[l_dom' p_c(1)*ones(8,1) lum(3)*ones(8,1);l_dom' p_c(2)*ones(8,1) lum(3)*ones(8,1);l_dom' p_c(3)*ones(8,1) lum(3)*ones(8,1)];
lpy_crom_l4=[l_dom' p_c(1)*ones(8,1) lum(4)*ones(8,1);l_dom' p_c(2)*ones(8,1) lum(4)*ones(8,1);l_dom' p_c(3)*ones(8,1) lum(4)*ones(8,1)];

lpy_acrom_l1=[500 0 lum(1)];
lpy_acrom_l2=[500 0 lum(2)];
lpy_acrom_l3=[500 0 lum(3)];
lpy_acrom_l4=[500 0 lum(4)];

% Genero una imagen indexada con una estrellita de colores

im=26*ones(15,15);

im(2,2)=17;
im(2,8)=18;
im(2,14)=19;
im(4,4)=9;
im(4,8)=10;
im(4,12)=11;
im(6,6)=1;
im(6,8)=2;
im(6,10)=3;
im(8,2)=24;
im(8,4)=16;
im(8,6)=8;
im(8,8)=25;
im(8,10)=4;
im(8,12)=12;
im(8,14)=20;
im(10,6)=7;
im(10,8)=6;
im(10,10)=5;
im(12,4)=15;
im(12,8)=14;
im(12,12)=13;
im(14,2)=23;
im(14,8)=22;
im(14,14)=21;


lpy1=[lpy_crom_l1;lpy_acrom_l1];
t1=lp2coor(lpy1,tipo,T_l,Yw);
T1=coor2tri(t1,Yw);
[map1,saturat,Tn]=tri2val([T1;Tfondos(4,:)],Yw,tm,a,g,8);
figure(12),colormap(map1),image(im),axis('off')
set(12,'Position',[0*ancho_pant/4 2*alto_pant/3 ancho_pant/4 0.9*alto_pant/3])

lpy2=[lpy_crom_l2;lpy_acrom_l2];
t2=lp2coor(lpy2,tipo,T_l,Yw);
T2=coor2tri(t2,Yw);
[map2,saturat,Tn]=tri2val([T2;Tfondos(4,:)],Yw,tm,a,g,8);
figure(13),colormap(map2),image(im),axis('off')
set(13,'Position',[1*ancho_pant/4 2*alto_pant/3 ancho_pant/4 0.9*alto_pant/3])

lpy3=[lpy_crom_l3;lpy_acrom_l3];
t3=lp2coor(lpy3,tipo,T_l,Yw);
T3=coor2tri(t3,Yw);
[map3,saturat,Tn]=tri2val([T3;Tfondos(4,:)],Yw,tm,a,g,8);
figure(14),colormap(map3),image(im),axis('off')
set(14,'Position',[2*ancho_pant/4 2*alto_pant/3 ancho_pant/4 0.9*alto_pant/3])

lpy4=[lpy_crom_l4;lpy_acrom_l4];
t4=lp2coor(lpy4,tipo,T_l,Yw);
T4=coor2tri(t4,Yw);
[map4,saturat,Tn]=tri2val([T4;Tfondos(4,:)],Yw,tm,a,g,8);
figure(15),colormap(map4),image(im),axis('off')
set(15,'Position',[3*ancho_pant/4 2*alto_pant/3 ancho_pant/4 0.9*alto_pant/3])
% disp(' ')
% disp(' ')
% disp(' Press the INTRO key to continue!')
% disp(' ')
% disp(' ')
% lala = input(' ');

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  Incrementando la iluminacion se incrementa Q, pero J permanece mas o
%  menos constante
%  

% figure(16),
% axis([0 1 0 1]),axis('off'),text(0,0.7,'CLARIDAD (2/3): constante con iluminacion','FontSize',14);
% disp(' ')
% disp(' ')
% disp(' Press the INTRO key to continue!')
% disp(' ')
% disp(' ')
% lala = input(' ');

disp(' ')
disp(' LIGHTNESS (2/3): constant with illumination level')
disp(' Press the INTRO key to continue!')
disp(' ')
disp(' ')
lala = input(' ');

% Vamos a pintar las estrellitas y los respectivos colores

lpy1=[lpy_crom_l1;lpy_acrom_l1];
t1=lp2coor(lpy1,tipo,T_l,Yw);
T1=coor2tri(t1,Yw);
[map1,saturat,Tn]=tri2val([T1;Tfondos(1,:)],Yw,tm,a,g,8);
figure(16),colormap(map1),image(im),axis('off')
set(16,'Position',[0*ancho_pant/4 1*alto_pant/3 ancho_pant/4 0.9*alto_pant/3])

lpy2=[lpy_crom_l2;lpy_acrom_l2];
t2=lp2coor(lpy2,tipo,T_l,Yw);
T2=coor2tri(t2,Yw);
[map2,saturat,Tn]=tri2val([T2;Tfondos(2,:)],Yw,tm,a,g,8);
figure(17),colormap(map2),image(im),axis('off')
set(17,'Position',[1*ancho_pant/4 1*alto_pant/3 ancho_pant/4 0.9*alto_pant/3])

lpy3=[lpy_crom_l3;lpy_acrom_l3];
t3=lp2coor(lpy3,tipo,T_l,Yw);
T3=coor2tri(t3,Yw);
[map3,saturat,Tn]=tri2val([T3;Tfondos(3,:)],Yw,tm,a,g,8);
figure(18),colormap(map3),image(im),axis('off')
set(18,'Position',[2*ancho_pant/4 1*alto_pant/3 ancho_pant/4 0.9*alto_pant/3])

lpy4=[lpy_crom_l4;lpy_acrom_l4];
t4=lp2coor(lpy4,tipo,T_l,Yw);
T4=coor2tri(t4,Yw);
[map4,saturat,Tn]=tri2val([T4;Tfondos(4,:)],Yw,tm,a,g,8);
figure(19),colormap(map4),image(im),axis('off')
set(19,'Position',[3*ancho_pant/4 1*alto_pant/3 ancho_pant/4 0.9*alto_pant/3])
% disp(' ')
% disp(' ')
% disp(' Press the INTRO key to continue!')
% disp(' ')
% disp(' ')
% lala = input(' ');

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  Incrementando la reflectancia del fondo sin variar las muestras 
%  disminuye la claridad (por definicion) y disminuye la luminosidad por induccion
%

% figure(20),
% axis([0 1 0 1]),axis('off'),text(0,0.7,'CLARIDAD (3/3): entorno','FontSize',14);
% disp(' ')
% disp(' ')
% disp(' Press the INTRO key to continue!')
% disp(' ')
% disp(' ')
% lala = input(' ');

disp(' ')
disp(' LIGHTNESS (3/3): Depends on the surround')
disp(' Press the INTRO key to continue!')
disp(' ')
disp(' ')
lala = input(' ');

lum_fondo=[60 90 130 170]; % Fondo claro
% lum_fondo=[70 90 130 170];       % EJEMPLO BONITO: Este fondo de 70cd/m2 con las muestras
% que tenemos aqui dan lugar a que las muestras centrales se diferencien del fondo con
% dificultad porque son casi acromaticas y equiluminosas
%lum_fondo=1.2*[5 10 20 40]; % Fondo oscuro
crom_fondo=[0.3333 0.3333];  % Fondo acromatico
tYfondos=[crom_fondo(ones(4,1),:) lum_fondo'];
Tfondos=coor2tri(tYfondos,Yw);


lpy4=[lpy_crom_l4;lpy_acrom_l4];
t4=lp2coor(lpy4,tipo,T_l,Yw);
t4(:,3)=50*ones(size(t4,1),1);
T4=coor2tri(t4,Yw);

[map1,saturat,Tn]=tri2val([T4;Tfondos(1,:)],Yw,tm,a,g,8);
figure(20),colormap(map1),image(im),axis('off')
set(20,'Position',[3*ancho_pant/4 40 ancho_pant/4 0.9*alto_pant/3])

[map2,saturat,Tn]=tri2val([T4;Tfondos(2,:)],Yw,tm,a,g,8);
figure(21),colormap(map2),image(im),axis('off')
set(21,'Position',[2*ancho_pant/4 40 ancho_pant/4 0.9*alto_pant/3])

[map3,saturat,Tn]=tri2val([T4;Tfondos(3,:)],Yw,tm,a,g,8);
figure(22),colormap(map3),image(im),axis('off')
set(22,'Position',[1*ancho_pant/4 40 ancho_pant/4 0.9*alto_pant/3])

[map4,saturat,Tn]=tri2val([T4;Tfondos(4,:)],Yw,tm,a,g,8);
figure(23),colormap(map4),image(im),axis('off')
set(23,'Position',[0*ancho_pant/4 40 ancho_pant/4 0.9*alto_pant/3])
disp(' ')
disp(' ')
disp(' Press the INTRO key to continue!')
disp(' ')
disp(' ')
lala = input(' ');
close all

%% Solo por manterner la definicion de antes, recordemos que...
%
%   - Colorido (Colorfulness o M): 
%      Atributo perceptual segun el cual un estimulo parece mas o menos 
%      cromatico
%   

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%   - Croma (Chroma o C)
%
%      Buena: Colorido de una muestra juzgada en proporcion a la luminosidad
%             de un estimulo igualmente iluminado que se perciba como
%             acromatico y muy luminoso.
%


% Evidentemente, si crece el colorido sobre un fondo constante tambien
% crece el croma (analogamente a lo que ocurria con claridad/luminosidad al incremntar las reflectancias de las muestras)

% Tomese la figura 11...

figure(11)

% Sin embargo, si incrementamos la luminosidad en tandem (p.ej. cambiando la iluminacion)
% el croma permanece mas o menos constante (identifica una propiedad del objeto) 
%
% Ejemplo: Serie de croma constante obtenida cambiando el nivel de iluminacion de
% una escena
%
% Otro ejemplo: tomense las figuras 16 a 19

% figure(24),
% axis([0 1 0 1]),axis('off'),text(0,0.7,'CROMA (1/2): constante con iluminacion','FontSize',14);
% disp(' ')
% disp(' ')
% disp(' Press the INTRO key to continue!')
% disp(' ')
% disp(' ')
% lala = input(' ');

disp(' ')
disp(' CHROMA (1/2): constant with illumination')
disp(' Press the INTRO key to continue!')
disp(' ')
disp(' ')
lala = input(' ');

l=570;
Y=15;
Ylw=25;k=linspace(1,7,10)';
k=k(1:2:10);
pc=0.8;
lpY=[l*ones(5,1) pc*ones(5,1) Y*k];
xyY=lp2coor(lpY,2,T_l,Yw);
XYZ=coor2tri(xyY,Yw);
XYZ0w=val2tri([1 1 1],Yw,tm,a,g);
xyY0w=tri2coor(XYZ0w,Yw);
xyYw=[xyY0w(ones(5,1),1:2) Ylw*k];
XYZw=coor2tri(xyYw,Yw);
[n,saturat,XYZn]=tri2val([XYZ;XYZw],Yw,tm,a,g,8);
%figure;colordgm(XYZn,1,T_l,Yw);
fig=23;
for i=1:5
 im=(5+i)*ones(5,5);im(3,3)=i;
 % figure(fig+i);imshow(im,n,'notruesize');
 figure(fig+i);colormap(n),image(im);
 set(fig+i,'Position',[(i-1)*ancho_pant/5 alto_pant/2 ancho_pant/5 0.9*alto_pant/2])
end

% Con lo cual, si no incrementamos la luminosidad en tandem (p.ej. incrementando la luminancia del fondo
% dejando fija la muestra) el croma disminuira aunque el parametro absoluto (colorido) no varie
% tanto (vete a saber si hay induccion)
%
% Otro ejemplo: tomense las figuras 20 a 23

% figure(29),
% axis([0 1 0 1]),axis('off'),text(0,0.7,'CROMA (2/2): depende del fondo','FontSize',14);
% disp(' ')
% disp(' ')
% disp(' Press the INTRO key to continue!')
% disp(' ')
% disp(' ')
% lala = input(' ');

disp(' ')
disp(' CHROMA (2/2): Depends on background/surround')
disp(' Press the INTRO key to continue!')
disp(' ')
disp(' ')
lala = input(' ');

l=570;
Y=15;
Ylw=25;k=linspace(1,7,10)';
k=k(1:2:10);
pc=0.8;
lpY=[l*ones(5,1) pc*ones(5,1) Y*k(ones(5,1))];
xyY=lp2coor(lpY,2,T_l,Yw);
XYZ=coor2tri(xyY,Yw);
XYZ0w=val2tri([1 1 1],Yw,tm,a,g);
xyY0w=tri2coor(XYZ0w,Yw);
xyYw=[xyY0w(ones(5,1),1:2) Ylw*k];
XYZw=coor2tri(xyYw,Yw);
[n,saturat,XYZn]=tri2val([XYZ;XYZw],Yw,tm,a,g,8);
%figure;colordgm(XYZn,1,T_l,Yw);
fig=28;
for i=1:5
 im=(5+i)*ones(5,5);im(3,3)=i;
 %figure(fig+i);imshow(im,n,'notruesize');
 figure(fig+i);colormap(n),image(im);
  set(fig+i,'Position',[(i-1)*ancho_pant/5 40 ancho_pant/5 0.9*alto_pant/2])
end
disp(' ')
disp(' ')
disp(' Press the INTRO key to continue to SATURATION!')
disp(' ')
disp(' ')
lala = input(' ');
close all

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%   - Saturacion (saturation o s)
%
%      Buena: Colorido de una muestra juzgada en proporcion a su luminosidad
%

%En una serie de pureza colorimetrica constante y luminancia creciente, la
%saturacion es aproximadamente constante. Si los colores estan
%relacionados, podremos juzgar tambien su croma, que sera creciente, pero
%si no lo estan, no es posible juzgar mas que su saturacion.

% figure(24),
% axis([0 1 0 1]),axis('off'),text(0,0.7,'SATURACION: constante en un objeto sombreado','FontSize',14);
% disp(' ')
% disp(' ')
% disp(' Press the INTRO key to continue!')
% disp(' ')
% disp(' ')
% lala = input(' ');

disp(' ')
disp(' SATURATION: Constant over shadows')
disp(' Press the INTRO key to continue!')
disp(' ')
disp(' ')
lala = input(' ');

l=570;Y=linspace(10,100,10);
pc=0.4;
lpY=[l*ones(10,1) pc*ones(10,1) Y'];
lpY=[lpY;[lpY(:,1) 0.9*lpY(:,2)/pc lpY(:,3)]];
xyY=lp2coor(lpY,2,T_l,Yw);
XYZ=coor2tri(xyY,Yw);
XYZ0w=val2tri([1 1 1],Yw,tm,a,g);
xyY0w=tri2coor(XYZ0w,Yw);
xyYw=[xyY0w(ones(10,1),1:2) xyY(1:10,3)];
XYZw=coor2tri(xyYw,Yw);
XYZw=[XYZw;XYZ0w];
[n,saturat,XYZn]=tri2val([XYZ;XYZw],Yw,tm,a,g,8);
%figure;colordgm(XYZn,1,T_l,Yw);
im=31*ones(9,16);im(3:7,4:13)=[21:30;1:10;31*ones(1,10);21:30;11:20];
%figure(34);imshow(im,n,'notruesize');
figure(34);colormap(n),image(im);

%figure(35);imshow(im,n,'notruesize');
% %En una serie de pureza colorimetrica constante y luminancia creciente, la
% %saturacion es aproximadamente constante. Si los colores estan
% %relacionados, podremos juzgar tambien su croma, que sera creciente, pero
% %si no lo estan, no es posible juzgar mas que su saturacion.
% 
% l=570;Y=linspace(10,100,10);
% pc=0.6;
% lpY=[l*ones(10,1) pc*ones(10,1) Y'];
% lpY=[lpY;[lpY(:,1) 0.8*lpY(:,2)/pc lpY(:,3)]];
% xyY=lp2coor(lpY,2,T_l,Yw);
% XYZ=coor2tri(xyY,Yw);
% XYZ0w=val2tri([1 1 1],Yw,tm,a,g);
% xyY0w=tri2coor(XYZ0w,Yw)
% xyYw=[xyY0w(ones(10,1),1:2) xyY(1:10,3)];
% XYZw=coor2tri(xyYw,Yw);
% XYZw=[XYZw;0*XYZ0w];
% [n,saturat,XYZn]=tri2val([XYZ;XYZw],Yw,tm,a,g,8);
% figure;colordgm(XYZn,1,T_l,Yw);
% im=31*ones(9,16);im(3:7,4:13)=[21:30;1:10;31*ones(1,10);21:30;11:20];
% figure;imshow(im,n,'notruesize');
