function Lab=xyz2lab(C,W)

% XYZ2LAB computes the lightness, L*, and the chromatic coordinates a* and b* in CIELAB
% of a set of colours defined by their tristimulus CIE-1931 values.
%
% CIELAB is a simple appearance model providing perceptual descriptors (lightness, hue
% and chroma) for related colours (colours in a scene).
%
% In this representation, information about the illumination conditions or, alternatively,
% about the scene, is included in a reference stimulus. Using CIELAB in the standard
% conditions implies that the reference stilulus is a perfect difuser illuminated as the
% test.
% 
% SYNTAX
% ----------------------------------------------------------------------------
% LAB=xyz2lab(XYZ,XYZR)
%
% XYZ = Tristimulus values of the test stimuli.
%       For N colours, this is a Nx3 matrix.
%
% XYZR = Tristimulus values of the reference stimulus.
%        If the reference stimulus is the same for all the test stimuli, this
%        is a 1x3 matrix. If the reference is different for each tes stimulus
%        XYZR is a Nx3 matrix.
%
% LAB  = For N colours, Nx3 matrix, containing, in columns, the lightness L*,
%        and the chromaticity coordinates a* and b*.
%
% RELATED FUNCTIONS
% ----------------------------------------------------------------------------
% lab2xyz, lab2perc, perc2lab
%

s=size(C);
ss=size(W);
if ss(1)~=s(1)
   W=repmat(W,s(1),1);
end
con=(C./W)>0.008856;
F=((C./W).^(1/3)).*con+(903.3*(C./W)+16).*(1-con)/116;
Lab(:,1)=116*F(:,2)-16;
Lab(:,2)=500*(F(:,1)-F(:,2));
Lab(:,3)=200*(F(:,2)-F(:,3));
