function [nm,em]=miniecol2(n0,Td,l,a,g,coco,utri)

% MINIECOL obtiene (por busqueda exhaustiva en un entorno de N0) la terna de niveles digitales
% que minimizan el error euclideo entre el color generado y el deseado.
% Podemos controlar el tamao del area de busqueda mediante el parametro 'lado' que fija el
% lado del cubo de ternas de niveles digitales entorno a N0.
% 
% Si en un primer bucle el minimo se obtiene en un extremo del area de busqueda, se realiza
% otra busqueda centrada en este nuevo punto.
%
% El proceso se detiene cuando el mnimo se encuentra en el interior del area de busqueda o
% cuando se llega a un extremo del area total de busqueda (cubo [0,0,0]-[Nmax,Nmax,Nmax])
%
% [nn,en]=miniecol(n0,T,lado,a,g,coco,utri)
%
% REQUIRED FUNCTIONS
% --------------------------------------------------------------------------------------------
%   errcol.m  ganadora.m
% niv2coor.m

s=size(coco);
Nmax=coco(1,s(2));

em=errcol(Td,n0,a,g,coco,utri);
nm=n0;

%l=ceil(l/2); Quito esto porque ahora el lado del volumen de busqueda viene dado por 
%             la resolucion en bits, y es un numero real.

cond=0;

kkk=0;
while cond==0
    kkk=kkk+1;
    if kkk>2000
       cond=1;
    end 
    m=n0-l;
    m(m<0)=0;
    M=n0+l;
    M(M>Nmax)=Nmax;
    [n1,n2,n3]=meshgrid(m(1):(M(1)-m(1))/2:M(1),m(2):(M(2)-m(2))/2:M(2),m(3):(M(3)-m(3))/2:M(3));
    n=[reshape(n1,numel(n1),1) reshape(n2,numel(n2),1) reshape(n3,numel(n3),1)];
    clear n1 n2 n3
    Y=repmat(a,size(n,1),1).*n.^repmat(g,size(n,1),1);
    coor=niv2coor2(n,coco);
   
    for i=1:3
        T(:,:,i)=coor2tri([coor(:,:,i) Y(:,i)],utri);
    end
    Tg=sum(T,3);
    e=diag((repmat(Td,size(Tg,1),1)-Tg)*(repmat(Td,size(Tg,1),1)-Tg)');
    [emm,ord]=min(e);
    
    if emm<em
        em=emm;
        nm=n(ord,:);
    end
    
    c=+((nm>m)&(nm<M)); 
    c((nm==0)|(nm==Nmax))=1;
    if prod(c)==1
       cond=1;
    else 
       n0=nm;
    end
end