function [coor]=niv2coor(n,coco)

% NIV2COOR calcula las coordenadas cromaticas de los 
% primarios del monitor para unos valores de los niveles
% digitales a partir de la matriz experimental de variacion
% de las coordenadas con el nivel digital:
%
% La variacion de las coordenadas cromaticas con el nivel
% digital se introduce mediante la matriz 'coco', que contiene en cada columna las coor-
% denadas de cada primario en un conjunto de niveles digitales (que incluyen 0 y Nm) dados 
% por la primera fila de dicha matriz:
%
%              /    0     ......     Nmax     \
%              | t1(P1(0)) ...... t1(P1(Nmax)) |
%              | t2(P1(0)) ...... t2(P1(Nmax)) |  
%              | t1(P2(0)) ...... t1(P2(Nmax)) |  
%       coco = | t2(P2(0)) ...... t2(P2(Nmax)) |  
%              | t1(P3(0)) ...... t1(P3(Nmax)) |  
%              \ t2(P3(0)) ...... t2(P3(Nmax)) / 
%
%
% Lo que se hace es interpolacion lineal.
%
% USO: coor=niv2coor(n,coco);
%
% REQUIRED FUNCTIONS
% ---------------------------------------------------------------------------------
% ganadora.m
% 


Nmax=coco(1,end);
                  coorr=interp1(coco(1,:),coco(2:3,:)',n(:,1));
                  coorg=interp1(coco(1,:),coco(4:5,:)',n(:,2));
                  coorb=interp1(coco(1,:),coco(6:7,:)',n(:,3));

                  coor(:,:,1)=coorr;
                  coor(:,:,2)=coorg;
                  coor(:,:,3)=coorb;
