
(defmacro view 
  (plot-cell-code-lol 
         &key statistical-object (menu-title "SpreadPlot") show 
         (local-links t) (title (strcat "View of " (send @ :title)))
         rel-widths rel-heights span-right span-down
         (data-object $) (container nil) (style 1))
;not used  supplemental-plot location (size (floor (* .9 (effective-screen-size))))
"Args: plot-functions
       &KEY statistical-object (menu-title \"SpreadPlot\") show 
            (local-links t) (title title)
            rel-widths rel-heights span-right span-down
            (data-object $) (container nil) (style 0)
PLOT-FUNCTIONS is a list of lists, where each element is either a plot function or a list of plot functions, where plot functions are functions in the set of new plot functions"
;not used  supplemental-plot location (size (floor (* .9 (effective-screen-size))))
  (if container
      (enable-container (eval container))
      (setf container (send data-object :create-spreadplot-container style)))
  (let* ((sizes (list (length plot-cell-code-lol) 
                      (length (first plot-cell-code-lol))))
         (num-plotcells (apply #'* sizes))
         (plot-cell-code-matrix (make-array sizes :initial-contents plot-cell-code-lol))
         (plot-cell-code-list 
          (coerce (make-array num-plotcells :displaced-to plot-cell-code-matrix) 'list))
         (rel-widths (if rel-widths rel-widths (repeat 1 (second sizes))))
         (rel-heights (if rel-heights rel-heights (repeat 1 (first sizes))))
         (aspect-ratio (/ (- (first (effective-screen-size)) 8)
                          (- (second (effective-screen-size)) 42)))
         (wild-card-value (- (* aspect-ratio (sum rel-heights)) (sum rel-widths)))
         (width-wild-card-loc (which (= 0 rel-widths)))
         (height-wild-card-loc (which (= 0 rel-heights)))
         (view container)
         (result)
         (plot-symbol)
         (plot-object-list)
         (splot))
    (cond
      ((> (length (remove nil (combine width-wild-card-loc height-wild-card-loc))) 1)
       (error "cannot have more than one wildcard height and width"))
      ((not (not width-wild-card-loc))
       (setf (select rel-widths width-wild-card-loc) wild-card-value))
      ((not (not height-wild-card-loc))
       (setf (select rel-heights height-wild-card-loc) wild-card-value)))
    (dolist (plot-cell-code plot-cell-code-list)
            (setf plot-symbol (first plot-cell-code))
            (setf result 
                  (case plot-symbol
                    (histogram-plot    (histogram-plot    $ :in view :linked t))
                    (distribution-plot (distribution-plot $ :in view))
                    (cumulative-plot   (cumulative-plot   $ :in view :linked t))
                    (comparison-plot   (comparison-plot   $ :in view))
                    (dot-plot          (dot-plot          $ :in view :linked t))
                    (scatter-plot      (scatter-plot      $ :in view :linked t))
                    (scatter-matrix    (scatter-matrix    $ :in view :linked t))
                    (spinning-plot     (spinning-plot     $ :in view :linked t))
                    (orbiting-plot     (orbiting-plot     $ :in view :linked t))
                    (line-plot         (line-plot         $ :in view :linked t))
                    (box-plot          (box-plot          $ :in view :linked t))
                    (diamond-plot      (diamond-plot      $ :in view :linked t))
                    (catbox-plot       (catbox-plot       $ :in view :linked t))
                    (paracoord-plot    (paracoord-plot    $ :in view :linked t))
                    (mosaic-plot       (mosaic-plot       $ :in view))
                    (bar-graph         (bar-graph         $ :in view))
                    (labels-list       (labels-list       $ :in view :linked t))
                    (variables-list    (variables-list    $ :in view))
                    (categories-list   (categories-list   $ :in view))
                    (datasheet         (datasheet         $ :in view))
                    (nil               nil)
                    (t                 (error-message "unknown plot function"))))
            (setf plot-object-list (append plot-object-list (list result))))
    (setf splot (spreadplot (matrix sizes plot-object-list)
                            :rel-widths rel-widths
                            :rel-heights rel-heights
                            :span-down (matrix sizes (combine span-down))
                            :span-right (matrix sizes (combine span-right))
                            :container view
                            :title title
                            :statistical-object statistical-object
                            :local-links local-links
                            ))
    (send splot :show-spreadplot)
    (disable-container)
    (defmeth container :close () (send self :hide-window))
    splot
    ))


(view (( (variables-list) (mosaic-plot) (catbox-plot) (labels-list) )
       ( (categories-list) (datasheet)       nil           nil      ))
      :rel-widths (.4 1 1 0)
      :span-down  ((1 1 1 2) (1 1 0 0))
      :span-right ((1 1 1 1) (1 2 0 0))
      :style 7); 0=seamless 1=borders 7=borders+titles