library(tidyverse)

df_acb <- read_csv("df_acb.csv")

# Copy for later use:
df_acb_copy <- df_acb

df_acb <- df_acb %>%
  select(-Season)
b_aux <- spread(df_acb, key = Age, value = PIR)
b_aux1 <- as.data.frame(b_aux)
rownames(b_aux1) <- b_aux1$Name
b <- b_aux1[, -1]
w <- b
w[!is.na(w)] <- 1
w[is.na(w)] <- 0
dim(b) ; dim(w)
#[1] 2800   29
#[1] 2800   29

old_ages <- b[, colnames(b) %in% 40:44] 
old_ages[rowSums(is.na(old_ages)) != 4,] # There is no age 43.
#                      40   41   42 44
#Creus, Joan~AD9    11.60 10.7 12.7 NA
#Espil, Juan~AYP     3.60   NA   NA NA
#Higgins_Mike~AM3      NA  2.0  1.6 NA
#Hopkins, B.~A11     3.70   NA   NA NA
#Lewis, Larry~AIR    6.05  4.3   NA NA
#Middleton, D.~ALS   2.00  1.7   NA  2
#Rogers, Johnny~AJZ  6.20   NA   NA NA
#Turner, Andre~APJ     NA 10.9   NA NA
#Varner, Bill~AZL      NA  3.4   NA NA
# 9 values bigger for ages larger than 40.

young_ages <- b[, colnames(b) %in% 15:18] 
View(young_ages[rowSums(is.na(young_ages)) != 4,])
# Luka Doncic, Angel Rebolo and Ricky Rubio have values in the column 15.
# Since Doncic and Ricky played in the NBA I think it is important to keep their values.
# https://as.com/baloncesto/2016/10/30/acb/1477837644_283707.html

b_pir_acb <- b[, colnames(b) %in% 15:40]
w_pir_acb <- w[, colnames(b) %in% 15:40]
save(b_pir_acb, file = "b_pir_acb.RData")
save(w_pir_acb, file = "w_pir_acb.RData")

# There is one NA:
#table(is.na(df_acb$PIR))
#df_acb[is.na(df_acb$PIR),]
#                     Name PIR Age
#1851 De Cobos, Carlos~Y70 NaN  22

df_pir_acb <- df_acb_copy %>%
  filter(Age >= 15 & Age < 41) %>%
  arrange(Name, desc(Age)) %>%
  na.omit() 
range(df_pir_acb$Age)
#[1] 15 40
write_csv(df_pir_acb, path = "df_pir_acb.csv")
# No Nas in data:
#table(is.na(df_pir_acb$PIR))
#table(is.na(df_pir_acb$Age))
#table(is.na(df_pir_acb$Name))