library(tidyverse)

# Set working directory.
#setwd("~/.../Code_and_Data_v1")

load("BPM/b_bpm.RData")
load("WS/b_ws.RData")

players <- c("Drazen Petrovic*_petrodr01", "Arvydas Sabonis*_sabonar01", "LeBron James_jamesle01", 
             "Joel Embiid_embiijo01", "Kareem Abdul-Jabbar*_abdulka01")

# BPM:
df_bpm <- data.frame()
for (i in players) {
  values <- as.vector(as.matrix(b_bpm[which(rownames(b_bpm) == i),]))
  df_new <- data.frame(Ages = as.numeric(colnames(b_bpm)), Value = values, Player = i, Variable = "BPM")
  df_bpm <- rbind.data.frame(df_bpm, df_new)
}
df_bpm1 <- na.omit(df_bpm)

# WS:
df_ws <- data.frame()
for (i in players) {
  values <- as.vector(as.matrix(b_ws[which(rownames(b_ws) == i),]))
  df_new <- data.frame(Ages = as.numeric(colnames(b_ws)), Value = values, Player = i, Variable = "Win Shares")
  df_ws <- rbind.data.frame(df_ws, df_new)
}
df_ws1 <- na.omit(df_ws)

df <- rbind(df_bpm1, df_ws1)
df$Player <- gsub("_.*$", "", df$Player)
df$Player <- gsub("\\*", "", df$Player)

ggplot(data = df, aes(x = Ages, y = Value, group = Player, color = Player)) +
  geom_line() +
  facet_wrap(~Variable, scales = "free_y") +
  labs(x = "Age (years)", y = "") +
  theme(legend.title = element_blank(),
        strip.text = element_text(size = 20),
        axis.text = element_text(size = 15),
        axis.title.x = element_text(size = 15),
        legend.text = element_text(size = 12),
        legend.key.size = unit(2, 'lines'))
ggsave("Figures/Fig1.eps", width = 8)
