library(tidyverse)

# List with the BPM and WS values for the sample of players: 
load("list_pl_app.RData") # Obtained with .../Predictions/do_data_app.R
VariableName <- list_pl_app
name_players <- sort(names(VariableName))
name_players1 <- as.character(sapply(name_players, function(x) strsplit(x, "_")[[1]][1]))
name_players2 <- unique(name_players1)[-1] # players' names

name <- c("Devin Booker", "Clint Capela", "Joel Embiid", "Nikola Jokic", 
          "Tyus Jones", "Zach LaVine", "Donovan Mitchell", "Jayson Tatum")
variable <- c("BPM", "WS")

df1_plot <- data.frame()
df2_plot <- data.frame()
for (i in 1:length(name)) {
  for (j in 1:length(variable)) {
    player_var <- paste(name[i], "_", variable[j], sep = "")
    pl_sel <- which(names(VariableName) == player_var)
    
    b <- VariableName[[pl_sel]][[3]]#$b_12
    q <- VariableName[[pl_sel]][[4]]
    
    if (variable[j] == "BPM") {
      player <- VariableName[[length(VariableName)]][pl_sel]
    }else{
      player <- VariableName[[length(VariableName)]][pl_sel - length(name_players2)]
    }
    
    sel_pl <- which(rownames(b) == player)
    # Latest non NA value:
    last_nonNA <- max(which(!is.na(b[sel_pl,])))
    
    pl <- b[sel_pl,]
    pl_noNA <- pl[!is.na(pl)]
    #pl_estim_future <- result$Z[sel_pl,][(last_nonNA + 1) : dim(result$Z)[2]]
    mid <- (dim(q)[1] + 1)/2
    pl_estim_future_1qu <- q[1, sel_pl, ][(last_nonNA + 1):dim(b)[2]]
    pl_estim_future_3qu <- q[mid, sel_pl, ][(last_nonNA + 1):dim(b)[2]]
    pl_estim_future_5qu <- q[5, sel_pl, ][(last_nonNA + 1):dim(b)[2]]
    
    ages <- c(names(pl_noNA), names(pl_estim_future_3qu))
    values <- c(as.vector(pl_noNA), as.vector(pl_estim_future_3qu))
    categ <- c(rep("Past values", length(pl_noNA)), 
               rep("Predictions", length(pl_estim_future_3qu)))
    
    ages1 <- names(pl_estim_future_1qu)
    values1 <- as.vector(pl_estim_future_1qu)
    values2 <- as.vector(pl_estim_future_5qu)
    
    df1 <- data.frame(Player = name[i], Variable = variable[j], Age = ages, Values = values, Type = categ) 
    df2 <- data.frame(Player = name[i], Variable = variable[j],
                      Age = ages, 
                      Values = values, 
                      Type = categ,
                      lwr = c(rep(NA, length(setdiff(ages, ages1))), values1), 
                      upr = c(rep(NA, length(setdiff(ages, ages1))), values2)) 
    
    df1_plot <- rbind(df1_plot, df1)
    df2_plot <- rbind(df2_plot, df2) 
  }
}
df1_plot$Age <- as.character(df1_plot$Age)

ggplot(df1_plot, aes(Age, Values, group = 1)) +
  facet_wrap(Player ~ Variable, scales = "free_y", ncol = 4) +
  geom_point(aes(colour = Type), size = 3) +
  geom_line(data = df2_plot, aes(colour = Type)) +
  geom_ribbon(data = df2_plot, aes(ymin = lwr, ymax = upr), alpha = 0.2) + 
  labs(x = "Ages (time points)", y = "") +
  scale_x_discrete(breaks = 19:40, 
                   labels = c(19, "", "", 22, "", "", 25, "", "", 28, "", "", 31, "", "", 
                              34, "", "", 37, "", "", 40)) +
  theme(legend.position = "none", 
        strip.text = element_text(size = 25),
        axis.text.x = element_text(size = 17, margin = margin(0,0,15,0), vjust = 0.1),
        axis.text.y = element_text(size = 17, vjust = -0.1),
        axis.title.x = element_text(size = 20))
# ggsave with .eps gives this issue: semi-transparency is not supported on this device.
#ggsave("Fig5.png", width = 16, height = 10) # Convert to eps from the terminal: $ convert Fig5.png Fig5.eps
