library(tidyverse)
library(MASS)
library(compiler)
library(parallel)
library(foreach)
library(doMC)
library(bigmemory)
library(synchronicity)

# Set working directory.
#setwd(".../Code_and_data_v1/")

# Ropes functions:
source("Algorithm/BAwR_internalROPES.R")
source("Algorithm/ropes.R")
source("Algorithm/executing_ropes.R")
source("Algorithm/forec_intervals_ropes.R")
source("do_similar_players.R")
source("Figures/do_plot_forec_players.R")

# Data:
df_ws <- read.csv("WS/df_ws.csv")
df_ws1 <- df_ws %>%
  filter(season == "2018", age < 24)
players_pred <- as.character(df_ws1$player_link)

# Load b and w matrices:
load("WS/b_ws.RData")
load("WS/w_ws.RData")

# Optimal lambda combination for ropes:
lambda2Ages <- 900
lambda1Ages <- 10
lambda0Ages <- 10

load("WS/player_names_ws.RData")
load("WS/res_ada_ws.RData")

alphas <- res_ada_ws$alphas
dimnames(alphas) <- list(player_names_ws[res_ada_ws$cases], player_names_ws) 

# Table 2 of the paper:
library(xtable)
name <- c("Devin Booker_bookede01", "Clint Capela_capelca01", "Joel Embiid_embiijo01", "Nikola Jokic_jokicni01",
          "Tyus Jones_jonesty01", "Zach LaVine_lavinza01", "Donovan Mitchell_mitchdo01", "Jayson Tatum_tatumja01")
table2 <- data.frame()
for (i in 1:length(name)) {
  tab <- round(alphas[, grep(name[i], colnames(alphas))], 2)
  table2 <- rbind(table2, tab)
}
dimnames(table2) <- list(c("D. Booker", "C. Capela", "J. Embiid", "N. Jokic", 
                           "T. Jones", "Z. LaVine", "D. Mitchell", "J. Tatum"), 
                         c("S. Burtt", "B. Wallace", "O. Birdsong", "L. James" ))
table2
xtable(table2)

# -----

numArchoid <- 5 
num_iter <- 5 # 10

list_pl <- vector("list", length(players_pred))
for (i in 1:length(players_pred)) {
  list_pl[[i]] <- list()
}
names_list <- as.character(sapply(players_pred, function(x) strsplit(x, "_")[[1]][1]))
names(list_pl) <- paste(names_list, "_", "WS", sep = "")

s0 <- Sys.time()
for (i in 1:length(players_pred)) {
  print(i)
  player <- players_pred[i]
  
  coef_alp <- alphas[, grep(player, colnames(alphas))]
  list_pl[[i]][[1]] <- coef_alp
  
  sim_pl <- do_similar_players(player, alphas, numArchoid, FALSE)
  # In order to avoid a long computational time, when the set of similar players
  # is very large, we restrict it to the first 100 players (and the target player 
  # itself). This makes sense, because we can assume that the rest of the players 
  # don't provide additional valuable information.
  if (length(sim_pl) > 200) {
    sim_pl <- c(sim_pl[1:100], sim_pl[length(sim_pl)])
  }
  list_pl[[i]][[2]] <- sim_pl
  
  res_ropes <- executing_ropes(sim_pl, b_ws, w_ws, lambda2Ages, lambda1Ages, lambda0Ages)
  list_pl[[i]][[3]] <- res_ropes$b_12
  cat("\n Done ropes!")
  
  res_fi <- forec_intervals_ropes(res_ropes, num_iter, lambda2Ages, lambda1Ages, lambda0Ages)
  list_pl[[i]][[4]] <- res_fi
  
  cat("\n Done!")
}
s1 <- Sys.time() - s0
s1
#Time difference of 5.118556 hours 

list_pl[[length(players_pred) + 1]] <- players_pred

list_pl_ws <- list_pl
save(list_pl_ws, file = "Predictions/list_pl_ws.RData")
