library(fpca)
library(tidyverse)

# Set working directory.
#setwd("~/.../WS")

df_ws <- read.csv("df_ws.csv")
df_ws <- df_ws %>%
  select(-season)

# Candidate models for fitting:
M.set <- c(5, 10, 15, 20)
r.set <- c(3, 4, 5)

#Fit candidate models by fpca.mle:
s0 <- Sys.time()
result_ws <- fpca.mle(as.data.frame(df_ws), M.set, r.set)
s1 <- Sys.time() - s0
s1
#Time difference of 25.83986 mins
#save(result_ws, file = "result_ws.RData")
#load("result_ws.RData")

#Model selection result, selected with the smallest CV score among all converged models:
M <- result_ws$selected_model[1]
r <- result_ws$selected_model[2]

# Look at the CV scores and convergence for each model:
result_ws$cv_scores
result_ws$converge
# Rescaled grid:
grids.new <- result_ws$grid
# Estimated eigenvalues:
evalest <- result_ws$eigenvalues
evalest

# Estimated error variance:
sig2est <- result_ws$error_var

# Estimated eigenfunctions:
eigenfest <- result_ws$eigenfunctions

va <- evalest[1] * eigenfest[1,] * eigenfest[1,] + 
  evalest[2] * eigenfest[2,] * eigenfest[2,] + 
  evalest[3] * eigenfest[3,] * eigenfest[3,] + 
  evalest[4] * eigenfest[4,] * eigenfest[4,] + 
  evalest[5] * eigenfest[5,] * eigenfest[5,]
plot(grids.new, sqrt(va))

#Estimated mean curve:
muest <- result_ws$fitted_mean

# If we wanted to exclude players with only one measurement:
#more_than_one <- df_ws %>% 
#  count(player_link) %>%
#  filter(n > 1) %>%
#  select(player_link) 

df_ws1 <- df_ws #%>% 
  #filter(player_link %in% more_than_one$player_link) 

L1 <- min(as.numeric(df_ws1$age)) # Range of the time.             
L2 <- max(as.numeric(df_ws1$age))

df_ws2 <- df_ws1 %>% 
  mutate(temp = (age - L1) / (L2 - L1)) %>%
  mutate(temp = ifelse(temp < 0.00001, 0.00001, temp)) %>%
  mutate(temp = ifelse(temp > 0.99999, 0.99999, temp)) %>%
  select(player_link, ws, temp) %>%
  rename(age = temp)

player_names_ws <- as.character(unique(df_ws2$player_link))
#save(player_names_ws, file = "player_names_ws.RData")
#load("player_names_ws.RData")

fpcs <- fpca.score(as.matrix(df_ws2), grids.new, muest, evalest, eigenfest, sig2est, r)
pred <- fpca.pred(fpcs, muest, eigenfest) 
# Save table (fpcs will be used with FAA and FADA):
#write.table(fpcs, file = "fpcs.txt", col.names = FALSE, row.names = FALSE)
#fpcs <- read.table("Predictions/Files_from_diff_places/fpcs.txt")

# ----

# 3. FAA and FADA
library(Anthropometry)
X <- fpcs
numArch <- 10 
numRep <- 20
set.seed(2018)
s0 <- Sys.time()
lass_ws <- stepArchetypesRawData(data = X, numArch = 1:numArch, numRep = numRep, verbose = FALSE)
s1 <- Sys.time() - s0
s1
#Time difference of 12.47195 mins
screeplot(lass_ws)
#save(lass_ws, file = "lass_ws.RData")
#load("lass_ws.RData")

numArchoid <- 4 # Number of archetypoids according to the screeplot.
s0 <- Sys.time()
res_ada_ws <- archetypoids(numArchoid, data = X, step = FALSE, 
                           ArchObj = lass_ws, nearest = "cand_ns", sequ = TRUE)
s1 <- Sys.time() - s0
s1
#Time difference of 1.139718 mins
#save(res_ada_ws, file = "res_ada_ws.RData")
#load("res_ada_ws.RData")

str(res_ada_ws)
# Archetypoids:
cases <- player_names_ws[res_ada_ws$cases]
cases
#[1] "Steve Burtt_burttst01"  "Ben Wallace_wallabe01"  "Otis Birdsong_birdsot01"  "LeBron James_jamesle01" 
df_ws1 %>%
  filter(player_link %in% cases) %>%
  group_by(player_link) %>%
  summarise(mean_ws = mean(ws)) %>%
  arrange(desc(mean_ws))
#LeBron James_jamesle01    14.6                   
#Ben Wallace_wallabe01     5.84                  
#Otis Birdsong_birdsot01   4.03                  
#Steve Burtt_burttst01     0.00 

#df_ws1[df_ws1$player_link == cases[1], "ws"]
#mean(df_ws1[df_ws1$player_link == cases[4], "ws"])

# Alphas:
alphas <- res_ada_ws$alphas
dimnames(alphas) <- list(player_names_ws[res_ada_ws$cases], player_names_ws) 
names(which(alphas[4,] > 0.99)) # > 0.8

mean(df_ws1[df_ws1$player_link == "LeBron James_jamesle01", "ws"])
#[1] 14.64
mean(df_ws1[df_ws1$player_link == "Michael Jordan*_jordami01", "ws"])
#[1] 14.26

# SET OF SIMILAR PLAYERS:
player <- "Joel Embiid_embiijo01"
alphas[, grep(player, colnames(alphas))]
#Steve Burtt_burttst01   Ben Wallace_wallabe01  Otis Birdsong_birdsot01   LeBron James_jamesle01 
#            0.4175013               0.1784859                0.2895601                0.1144515
source(".../Code_and_data_v1/do_similar_players.R")
do_similar_players(player, alphas, numArchoid, FALSE)
