# Datos
x <- 0:24
lx <- c(
  1000, 968.5022006, 937.9493353, 908.3130559, 879.5658648,
  851.6810895, 824.6328575, 798.3960724, 772.9463909, 748.2601998,
  724.3145945, 701.0873573, 678.5569372, 656.7024297, 635.5035575,
  614.9406514, 594.9946325, 575.6469942, 556.879785, 538.6755921,
  521.017525, 503.8891999, 487.2747245, 471.1586834, 455.5261236
)

# Función de error (Suma de cuadrados)
error_fun <- function(b){
  lx_est <- 1000 / (1 - b^100) * (b^x - b^100)
  sum((lx - lx_est)^2)
}

# Estimación de b
res <- optimize(error_fun, interval = c(0, 1))
b_est <- res$minimum
b_est

# lx estimados usando b estimado
lx_est <- 1000 / (1 - b_est^100) * (b_est^x - b_est^100)

# Gráfico Observados vs Estimados
plot(x, lx, type='b', pch=19, col='blue', ylim=range(c(lx,lx_est)),
     xlab='x', ylab='lx', main='lx Observados vs lx Estimados')
lines(x, lx_est, type='b', pch=17, col='red')
legend("topright", legend=c("Observados","Estimados"), col=c("blue","red"), pch=c(19,17))

# Calcular R^2
SSE <- sum((lx - lx_est)^2)
SST <- sum((lx - mean(lx))^2)
R2 <- 1 - SSE/SST
R2
